match(function() {
    return this.data.cmd === 'newPdfReport';
})(

    block('app-main').mode('page-block')('p-statistic-report'),

    block('b-page').mode('title')(function() {
        return iget2('p-statistic-report', 'zakaz-statisticheskogo-otcheta', 'Заказ статистического отчета');
    })
);

block('p-statistic-report')(

    addJs()(true),

    content()(function() {
        var data = this.data,
            login = data.user_login,
            campaign = data.campaign || {},
            allowedInternals = u.consts('rights').enableInternalCampaigns && (
                campaign.type ?
                    u.campaign.isInternal(campaign.type) :
                    u.campaign.hasInternal(data.available_camp_types)
            );

        return {
            block: 'l-page',
            mods: {
                layout: '16-80'
            },
            content: [
                {
                    elem: 'row',
                    left: {
                        block: 'p-statistic-report',
                        elem: 'all-camps-link',
                        content: {
                            block: 'link',
                            url: allowedInternals ?
                                u.formatUrl({
                                    path: '/dna/grid/campaigns',
                                    query: {
                                        ulogin: login
                                    }
                                }) :
                                u.getUrl('showCamps', {
                                    ulogin: login
                                }),
                            content: hasLoginRights('is_any_client') ? iget2('p-statistic-report', 'vse-kampanii', 'Все кампании') : iget2('p-statistic-report', 'vse-kampanii-klienta', 'Все кампании клиента')
                        }
                    },
                    right: {
                        block: 'b-page-title',
                        title: applyCtx({
                            block: 'p-statistic-report',
                            elem: 'header'
                        })
                    }
                },
                {
                    elem: 'row',
                    left: true,
                    right: {
                        block: 'b-new-report-form',
                        mix: [{
                            block: 'p-statistic-report',
                            elem: 'new-report-form'
                        }],
                        isSuperReaderControl: hasLoginRights('superreader_control'),
                        isSupport: hasLoginRights('support'),
                        features: data.features,
                        url: data.SCRIPT,
                        ulogin: login,
                        camps: data.orders.map(function(camp) {
                            return {
                                cid: camp.cid,
                                title: (camp.name || iget2('p-statistic-report', 'novaya-kampaniya', 'Новая кампания')) + '&nbsp;(' + iget2('p-statistic-report', 'no', '№') + '&nbsp;' +
                                    camp.cid + ')',
                                total: camp.wallet_cid < 1 ?
                                    camp.total + '&nbsp;' + u.currencies.getName(camp.currency) :
                                    '',
                                isActive: camp.statusActive !== 'No',
                                startDate: camp.start_date,
                                type: camp.mediaType,
                                isAvailableForPostview: camp.isAvailableForPostview
                            };
                        }, this),
                        goalsList: data.goals_list
                    }
                },
                {
                    elem: 'row',
                    left: true,
                    right: {
                        block: 'p-statistic-report',
                        elem: 'ready-reports',
                        content: [
                            {
                                elem: 'ready-reports-header',
                                mix: [{
                                    block: 'i-clearfix'
                                }],
                                content: [
                                    {
                                        elem: 'ready-reports-title',
                                        content: iget2('p-statistic-report', 'gotovye-otchety', 'Готовые отчеты:')
                                    },
                                    {
                                        block: 'icon-text',
                                        mods: { size: 'ms', theme: 'alert' },
                                        mix: [{
                                            block: 'p-statistic-report',
                                            elem: 'reports-terms-warning'
                                        }],
                                        text: iget2('p-statistic-report', 'otchety-hranyatsya-ne-bolee', 'Отчеты хранятся не более 3-х месяцев')
                                    }
                                ]
                            },
                            {
                                block: 'b-statistic-reports-list',
                                mix: [{
                                    block: 'p-statistic-report',
                                    elem: 'reports-list'
                                }],
                                url: data.SCRIPT,
                                ulogin: login,
                                lang: data.lang
                            }

                        ]
                    }
                }
            ]
        };
    }),

    elem('header')(

        content()(function() {
            return iget2('p-statistic-report', 'statisticheskie-otchety', 'Статистические отчеты');
        }),

        match(function() {
            return this.data.uid && this.data.UID != this.data.uid;
        }).content()(function() {
            var data = this.data,
                clientTitle = u.escapeHTML(data.user_fio + ' (' + data.user_login + ')');

            return [
                iget2('p-statistic-report', 'statisticheskie-otchety-dlya-klienta', 'Статистические отчеты для клиента:'),
                '&nbsp;',
                !data.login_rights.superreader_control ?
                    {
                        block: 'link',
                        url: u.getUrl('modifyUser', {
                            rcmd: 'showCamps',
                            ulogin: data.user_login
                        }),
                        content: clientTitle
                    } :
                    clientTitle
            ];
        })
    )
);
