match(function() {
    return this.data.cmd === 'switchClChief';
})(

    block('app-main').mode('page-block')('p-switch-chief'),

    block('b-page').mode('title')(function() {
        return iget2('p-switch-chief', 'smenit-glavnogo-predstavitelya', 'Сменить "Главного" представителя');
    })
);

block('p-switch-chief')(

    addJs()(true),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '60'
            },
            content: [
                {
                    elem: 'row',
                    center: {
                        block: 'b-page-title',
                        title: iget2('p-switch-chief', 'smenit-glavnogo-predstavitelya', 'Сменить "Главного" представителя')
                    }
                },
                {
                    elem: 'row',
                    center: {
                        block: 'icon-text',
                        mods: { size: 'ms', theme: 'alert' },
                        mix: [{
                            block: 'p-switch-chief',
                            elem: 'notice'
                        }],
                        text: iget2(
                            'p-switch-chief',
                            'glavnyy-predstavitel-imeet-eksklyuzivnoe',
                            'Главный представитель имеет эксклюзивное право регистрировать новых и удалять существующих представителей. Главным может быть только один из ваших зарегистрированных представителей. При переназначении главного представителя текущий логин теряет возможность регистрировать и удалять представителей.'
                        )
                    }
                },
                {
                    elem: 'row',
                    center: {
                        block: 'p-switch-chief',
                        elem: 'form'
                    }
                }
            ]
        };
    }),

    elem('form').content()(function() {
        var data = this.data,
            reps = this.data.reps,
            uidPar = withUidPar({}),
            uidParKey = Object.keys(uidPar)[0];

        return {
            block: 'b-layout-form',
            action: data.SCRIPT,
            method: 'GET',
            mix: {
                block: 'p-switch-chief',
                elem: 'form'
            },
            mixes: {
                submit: [{
                    block: 'p-switch-chief',
                    elem: 'submit'
                }],
                label: [{
                    block: 'p-switch-chief',
                    elem: 'form-label'
                }]
            },
            hiddenInputs: [
                {
                    name: 'cmd',
                    value: data.FORM.cmd
                },
                {
                    name: uidParKey + '',
                    value: uidPar[uidParKey] + ''
                },
                {
                    name: 'save',
                    value: iget2('p-switch-chief', 'naznachit', 'Назначить')
                }
            ],
            rows: [{
                label: {
                    content: iget2('p-switch-chief', 'novyy-glavnyy-predstavitel', 'Новый "Главный" представитель') + ':'
                },
                control: {
                    block: 'select',
                    name: 'rep_login',
                    content: [
                        {
                            block: 'button',
                            content: reps.length ? reps[0].FIO + ' (' + reps[0].login + ')' : ''
                        },
                        {
                            elem: 'control',
                            content: reps.map(function(rep) {
                                return {
                                    elem: 'option',
                                    attrs: {
                                        value: rep.login + ''
                                    },
                                    content: rep.FIO + ' (' + rep.login + ')'
                                };
                            })
                        }
                    ]
                }
            }],
            submit: {
                block: 'p-switch-chief',
                elem: 'submit-wrap',
                content: {
                    block: 'button',
                    mix: [{
                        block: 'p-switch-chief',
                        elem: 'submit'
                    }],
                    content: iget2('p-switch-chief', 'naznachit', 'Назначить')
                }
            }
        };
    })
);
