match(function() {
    var data = this.data;

    return data.cmd === 'chooseCountryCurrency' && (data.display_touch_page && data.is_touch_interface || data.is_daas_interface);
})(

    block('app-main')(
        mode('page-block')('p-touch-welcome'),
        mode('is-footer-enabled')(false),
        mode('is-header-enabled')(false)
    ),

    block('b-page')(
        def().match(function() {
            return !this.pageParams;
        })(function() {
            return applyNext({
                pageParams: {
                    auxParams: {
                        showCampStat: null,
                        camp_count_for_transfer: null,
                        camp_count_with_sum: null,
                        exists_campaigns_for_edit: null,
                        be_shows: null,
                        cid_for_manage_vcards: null,
                        agencyLogin: null,
                        campsExist: null,
                        // данные из canvas
                        edit_camp: null,
                        transfer_money: null,
                        payCampaign: null,
                        showuid: null
                    }
                }
            });
        }),

        elem('static-js').replace()(function() {
            var data = this.data,
                nameField = 'name_' + data.lang,
                countries = data.countries.map(function(item) {
                    return {
                        val: item.region_id,
                        text: item[nameField],
                        main: data.main_countries[item.region_id]
                    }
                }),
                svnInfo = data.svn_info || {},
                devInfo = {
                    isBeta: data.is_beta,
                    isProduction: data.is_production,
                    svn: {}
                },
                officeCity = u.getOfficeCityFromData(data),
                officeContacts = applyCtx({ block: 'i-office-contacts' }).offices[officeCity],
                clientCountry = (data.client_country && typeof data.client_country === 'string') ?
                    data.client_country :
                    u._.get(data.client_country, 'region_id'),
                clientCurrency = (data.countries_currencies[clientCountry] || [])[0],
                rootProps,
                storeParams;

            if (data.is_beta) {
                devInfo.svn = {
                    branch: svnInfo.branch,
                    revision: svnInfo.revision
                };

                devInfo.dbInfo = {
                    configuration: data.CONFIGURATION,
                    shard: data.SHARD
                };

                devInfo.betaNumber = data.server_name.split('.')[0]
            }

            rootProps = {
                login: data.login || data.uname,
                welcomePageParams: {
                    countries: countries,
                    currencyByCountry: data.countries_currencies,
                    countryCurrencyChooseDisabled: !data.country_currency_choose_enabled,
                },
                isHeaderAvailable: true,
                enableSidebar: data.is_dna_sidebar_enabled,
            };

            storeParams = {
                login: data.login || data.uname,
                perlReqId: data.reqid,
                page: data.cmd,
                availableCampaignsTypes: u['b-choose-campaign-type'].dnaCampaignTypes(),
                officeContacts: officeContacts,
                devInfo: devInfo,
                welcomeParams: {
                    country: clientCountry,
                    currency: clientCurrency
                },
                tuneSecretKey: data.tune_secret_key
            };

            return [
                this.addUtilityScripts(),
                {
                    elem: 'js',
                    attrs: { crossorigin: 'anonymous' },
                    url: this.useLocalDna() ? this.getLocalDnaUrl('static/js/main.js') : this.expandStaticFileNameForDna('static/js/touchMain.' + this.lang + '.js')
                },
                {
                    elem: 'js',
                    content: '(function(){var root=document.getElementById("app-wrapper");' +
                        'if(root){' +
                        'if(dnaTouch.components.Root.initStore){ dnaTouch.components.Root.initStore(' + safeStringify(storeParams) + '); }' +
                        'var elem=dnaTouch.reactCreateElement(dnaTouch.components.Root,' + safeStringify(rootProps) + ');' +
                        'dnaTouch.reactDOMRender(elem,root);' +
                        '}})()'
                },
                this.addCtxDumpScript()
            ];
        }),

        mode('head')(function() {
            return [
                {
                    elem: 'meta',
                    attrs: {
                        name: 'viewport',
                        content: 'width=device-width,initial-scale=1,user-scalable=no'
                    }
                },
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-timing'
                    })
                },
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-error-counter'
                    })
                },
                !this.useLocalDna() && {
                    elem: 'css',
                    attrs: { crossorigin: 'anonymous' },
                    url: this.expandStaticFileNameForDna('static/css/touchMain.' + this.lang + '.css')
                },
                this.addFavicons()
            ];
        }),

        elem('body').replace()(function() {
            return [
                { elem: 'content' },
                { elem: 'static-js' }
            ];
        })
    )
);

block('p-touch-welcome')(
    content()(function() {
        return [
            {
                elem: 'app-wrapper',
                attrs: {
                    id: 'app-wrapper'
                },
                content: [
                    // DIRECT-110046: добавить skeleton для шапки
                    // {
                    //     block: 'b-header-skeleton'
                    // }
                ]
            }
        ];
    })
);
