match(function() {
    if (this.data.cmd === 'showDnaPayment' && (this.data.display_touch_page || this.data.FORM['enforce-touch'])) {
        return true;
    }

    if ((this.data.cmd === 'showDna' || this.data.cmd === 'showDnaPb') &&
        this.data.display_touch_page && this.data.is_touch_interface) {
        return true;
    }

    if (this.data.cmd === 'showDaas') {
        return true;
    }

    return false;
})(

    block('app-main')(
        mode('page-block')('p-touch'),
        mode('is-footer-enabled')(false),
        mode('is-header-enabled')(false)
    ),

    block('b-page')(
        def().match(function() {
            return !this.pageParams;
        })(function() {
            return applyNext({
                pageParams: {
                    auxParams: {
                        showCampStat: null,
                        camp_count_for_transfer: null,
                        camp_count_with_sum: null,
                        exists_campaigns_for_edit: null,
                        be_shows: null,
                        cid_for_manage_vcards: null,
                        agencyLogin: null,
                        campsExist: null,
                        // данные из cansvn s
                        edit_camp: null,
                        transfer_money: null,
                        payCampaign: null,
                        showuid: null
                    }
                }
            });
        }),

        elem('static-js').replace()(function() {
            var data = this.data,
                devInfo = {
                    isBeta: data.is_beta,
                    isProduction: data.is_production,
                    svn: {}
                },
                svnInfo = data.svn_info || {},
                officeCity = u.getOfficeCityFromData(data),
                officeContacts = applyCtx({ block: 'i-office-contacts' }).offices[officeCity],
                isDaas = data.cmd === 'showDaas',
                bootstrapParams;

            if (data.is_beta) {
                devInfo.svn = {
                    branch: svnInfo.branch,
                    revision: svnInfo.revision
                };

                devInfo.dbInfo = {
                    configuration: data.CONFIGURATION,
                    shard: data.SHARD
                };

                devInfo.betaNumber = data.server_name.split('.')[0]
            }

            bootstrapParams = {
                page: data.cmd,
                appContext: isDaas ? 'daas' : 'dna',
                assessorOfferAgreed: !!data.assessor_offer_accepted,
                login: data.login
            };

            return [
                this.addUtilityScripts(),
                {
                    elem: 'js',
                    attrs: { crossorigin: 'anonymous' },
                    url: this.useLocalDna() ? this.getLocalDnaUrl('static/js/main.js') : this.expandStaticFileNameForDna('static/js/touchMain.' + this.lang + '.js')
                },
                {
                    elem: 'js',
                    content: 'window.dnaBootstrapTouch(' + safeStringify(bootstrapParams) + ')'
                },
                this.addCtxDumpScript()
            ];
        }),

        mode('head')(function() {
            return [
                {
                    elem: 'meta',
                    attrs: {
                        name: 'viewport',
                        content: 'width=device-width,initial-scale=1,user-scalable=no'
                    }
                },
                {
                    elem: 'meta',
                    attrs: {
                        name: 'format-detection',
                        content: 'telephone=no'
                    }
                },
                {
                    elem: 'meta',
                    attrs: {
                        name: 'apple-mobile-web-app-capable',
                        content: 'yes'
                    }
                },
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-timing'
                    })
                },
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-error-counter'
                    })
                },
                !this.useLocalDna() && {
                    elem: 'css',
                    attrs: { crossorigin: 'anonymous' },
                    url: this.expandStaticFileNameForDna('static/css/touchMain.' + this.lang + '.css')
                },
                this.addFavicons()
            ];
        }),

        elem('body').replace()(function() {
            return [
                { elem: 'content' },
                { elem: 'static-js' }
            ];
        })

    )
);

block('p-touch')(
    content()(function() {
        return [
            {
                elem: 'app-wrapper',
                attrs: {
                    id: 'app-wrapper'
                },
                content: [
                    // {
                    //     block: 'b-header-skeleton'
                    // }
                ]
            }
        ];
    })
);
