BEM.DOM.decl({ block: 'p-transfer-between-campaigns', elem: 'campaign', modName: 'direction', modVal: 'from' }, {
    /**
     * Выполняется при изменении поля isTransferring модели и устанавливает модификатор transferring
     * соответствующий значению измененного поля модели
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     */
    transferringChangeHandler: function(e, data) {
        this.setMod('transferring', data.value ? 'yes' : '');
    },

    /**
     * Выполняется при изменении поля isDisabled модели и устанавливает модификатор disabled
     * соответствующий значению измененного поля модели
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     */
    disabledChangeHandler: function(e, data) {
        this.setMod('disabled', data.value ? 'yes' : '');
    },

    /**
     * Выполняется при изменении поля amount модели
     * обновляет состояние инпута и чекбокса
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     */
    amountChangeHandler: function(e, data) {
        var isTransferringAll = data.value == this.model.get('available');

        this.checkbox.setMod('checked', isTransferringAll ? 'yes' : '');
        /* Такой способ задания val не ошибка. Он работает в 10 раз быстрее стандартного .val() блока
        * Используется для ускорения реакции интерфейса
        * */
        this.input.elem('control').val(data.value ? data.value.toFixed(2) : '');
        this.input.setMod('disabled', isTransferringAll ? 'yes' : '');
    }
});
