BEM.DOM.decl({ block: 'p-transfer-between-campaigns', elem: 'campaign', modName: 'direction', modVal: 'to' }, {
    /**
     * Выполняется при изменении поля isKeceiving модели и устанавливает модификатор receiving
     * соответствующий значению измененного поля модели
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     */
    receivingChangeHandler: function(e, data) {
        this.setMod('receiving', data.value ? 'yes' : '');
    },

    /**
     * Выполняется при изменении поля isYqualReceive модели
     * обновляет модификаторы инпута и селекта в зависимости от состояния модели и измененному значению поля
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     */
    equalReceiveChangeHandler: function(e, data) {
        this.checkbox.setMod('checked', data.value ? 'yes' : '');
        this.input.setMod('disabled', (this.model.get('isEqualReceiveMode') && !data.value) ? 'yes' : '');
    },

    /**
     * Выполняется при изменении поля equalReceiveMode модели
     * обновляет модификатор инпута в зависимости от состояния модели и измененному значению поля
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     */
    equalReceiveModeChangeHandler: function(e, data) {
        this.input.setMod('disabled', (data.value !== this.model.get('isEqualReceive')) ? 'yes' : '');
    },

    /**
     * Выполняется при изменении поля isDisabled модели и устанавливает модификатор disabled
     * соответствующий значению измененного поля модели
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     */
    disabledChangeHandler: function(e, data) {
        this.setMod('disabled', data.value ? 'yes' : '');
    },

    /**
     * Выполняется при изменении поля amount модели и устанавливает значение инпута соответственно значению поля модели
     * @param {Object} e - объект события
     * @param {Object} data - доп. данные события
     */
    amountChangeHandler: function(e, data) {
        /* Такой способ задания val не ошибка. Он работает в 10 раз быстрее стандартного .val() блока
        * Используется для ускорения реакции интерфейса
        * */
        this.input.elem('control').val(data.value ? data.value.toFixed(2) : '');
    }
});
