block('p-transfer-between-campaigns').elem('campaign')(

    addJs()(function() {
        return {
            cid: this.ctx.campaign.cid,
            model: {
                params: {
                    id: this.ctx.campaign.cid,
                    name: 'm-money-transfer-campaign-' + this.elemMods.direction,
                    parentName: 'm-money-transfer-' + this.elemMods.direction,
                    parentId: this.elemMods.direction
                },
                data: this.ctx.campaign
            }
        };
    }),

    content()(function() {
        var isDisabled = this.elemMods.direction == 'from' && this.ctx.campaign.available <= 0,
            formatedRemaining = u.formatShowsOrMoney(this.ctx.campaign.remaining, 'money'),
            formatedAvailable = u.formatShowsOrMoney(this.ctx.campaign.available, 'money'),
            formatedCurrency = u.currencies.getName(this.data.work_currency);

        return [
            {
                name: 'data',
                data: [
                    {
                        block: 'b-icon',
                        attrs: {
                            alt: this.ctx.campaign.status
                        },
                        mix: {
                            block: 'p-transfer-between-campaigns',
                            elem: 'campaign-status-icon'
                        },
                        mods: {
                            'size-13': this.ctx.campaign.status == 'no-money' ? 'no-money' : 'money-transfer',
                            status: this.ctx.campaign.status
                        }
                    },
                    {
                        elem: 'campaign-data',
                        content: [
                            {
                                elem: 'campaign-name',
                                content: this.ctx.campaign.name
                            },
                            {
                                elem: 'campaign-number',
                                content: [
                                    iget2('p-transfer-between-campaigns', 'no', '№'),
                                    {
                                        elem: 'campaign-cid',
                                        content: this.ctx.campaign.cid
                                    },
                                    {
                                        elem: 'campaign-total',
                                        content: formatedRemaining + ' ' + formatedCurrency
                                    }
                                ]
                            }
                        ]
                    }
                ]
            },
            {
                name: 'available',
                title: formatedAvailable,
                data: formatedAvailable || '0.00'
            },
            {
                name: 'remaining',
                title: formatedRemaining,
                data: formatedRemaining || '0.00'
            },
            {
                name: 'input',
                data: {
                    block: 'input',
                    js: {
                        cid: this.ctx.campaign.cid
                    },
                    mods: {
                        clear: 'no',
                        disabled: isDisabled ? 'yes' : ''
                    },
                    placeholder: '0',
                    content: [
                        {
                            mix: {
                                block: 'p-transfer-campaign',
                                elem: 'input-control'
                            },
                            elem: 'control'
                        }
                    ]
                }
            },
            {
                name: 'checkbox',
                data: {
                    block: 'checkbox',
                    js: {
                        cid: this.ctx.campaign.cid
                    },
                    mods: {
                        disabled: isDisabled ? 'yes' : ''
                    }
                }
            }].map(function(td) {
                return {
                    elem: 'campaigns-table-list-cell',
                    content: {
                        elem: 'campaigns-table-list-txt',
                        attrs: { title: td.title || '' },
                        elemMods: { td: td.name },
                        content: td.data
                    }
                };
            }, this);
    })
);
