BEM.DOM.decl({ block: 'p-transfer-between-campaigns', elem: 'campaign' }, {
    onSetMod: {
        js: function() {
            var parentModel = BEM.MODEL.getOne({
                name: this.params.model.params.parentName,
                id: this.params.model.params.parentId
            });

            // Создаем и добавляем нашу модель в поле campaigns (models-list)
            // модели 'm-money-transfer-from' или 'm-money-transfer-to'
            this.model = parentModel.get('campaigns').add(BEM.MODEL.create({
                name: this.params.model.params.name,
                id: this.params.model.params.id
            }, this.params.model.data));

            this.hltHTML = BEMHTML.apply({
                block: 'p-transfer-between-campaigns',
                elem: 'hlt',
                tag: 'span',
                content: '%STR%'
            });

            u.graspSelf.call(this, {
                checkbox: 'checkbox inside',
                input: 'input inside'
            });
        },

        disabled: function(mod, val) {
            val = val ? 'yes' : '';

            this.input.setMod('disabled', val);
            this.checkbox.setMod('disabled', val);
        }
    },

    /**
     * Выполняет поиск элементов массива parts в полях модели
     * @param {Array} parts - массив строк
     */
    searchByParts: function(parts) {
        this.model.searchInFields(
            parts,
            function(field) {
                !this.hasMod('hidden', 'yes') && this._highlightMatch(parts, field);
                this.delMod('hidden');
            }.bind(this),
            function() {
                this.setMod('hidden', 'yes');
            }.bind(this)
        );
    },

    /**
     * Выполняет подсветку найденной подстроки
     * в DOM элементе 'campaign-' + field
     * по регулярному выражению на базе массива строк parts
     * @param {Array} parts - массив строк
     * @param {String} field - имя поля модели в котором найдено совпадение
     * @private
     */
    _highlightMatch: function(parts, field) {

        var hltParts = parts.map(function(part) { return part.replace(/(.)/g, '[$1]'); }),
            hltRegExp = new RegExp('(' + hltParts.join('|') + ')', 'ig');

        BEM.DOM.update(
            this.elem('campaign-' + field),
            this.model.get(field).toString().replace(hltRegExp, function(str) {
                return this.hltHTML.replace('%STR%', str);
            }.bind(this)));

        return this;
    },

    /**
     * Убирает подсветку с видимых элементов и модификатор hidden со скрытых
     */
    resetView: function() {
        if (!this.hasMod('hidden', 'yes')) {
            this.model.get('searchFields').forEach(function(field) {
                this.elem('campaign-' + field).html(this.model.get(field));
            }, this);
        } else {
            this.delMod('hidden');
        }
    }
});
