BEM.DOM.decl({ block: 'p-transfer-between-campaigns', elem: 'campaigns', modName: 'direction', modVal: 'from' }, {
    onSetMod: {
        js: function() {
            /*
            * Текстовки для заголовка таблицы - меняются при изменении типа переноса
            * */
            this.elemTexts = {
                title: [iget2('p-transfer-between-campaigns', 's-kampanii', 'С кампании'), iget2('p-transfer-between-campaigns', 's-kampaniy', 'С кампаний')]
            };

            /*
            * Определяем колбэки для контекстных событий:
            * 1) Обработка потри фокуса с инпута указания суммы - если пользователь вручную указывает сумму переноса
            * 2) Изменение чекбокса - если переносится вся доступная сумма
            * 3) Клик по ссылки групповой выборки
            * */
            this.callbacks = {
                inputBlur: function(id, val) {
                    this.collection.setOneCampAmount(this.collection.get('campaigns').getById(id), val);
                },
                checkboxChange: function(id, isChecked) {
                    if (!this.hasMod('processing')) {
                        this.collection.setOneCampAmount(
                            this.collection.get('campaigns').getById(id),
                            isChecked ? this.collection.get('campaigns').getById(id).get('available') : 0);
                    }
                },
                selectAll: function() {
                    this.setMod('processing', 'yes');
                    this.collection.setAllCampsMaxAmount(this.collection.getNotDisabledCampaigns());
                    this.delMod('processing');
                }
            };

            this.__base.apply(this, arguments);

            /*
            * В качестве оптимизация делегируем отлов событий моделей кампаний списку
            * Слушаем изменение поля модели и вызываем метод представления кампании для обновления UI.
            * методы определяются в модифицированном p-transfer-between-campaigns__campaign
            * */
            BEM.MODEL.on( 'm-money-transfer-campaign-from' , 'isTransferring', 'change', function(e, data) {
                this._getRowView(e.target.model.id).transferringChangeHandler(e, data);
            }, this)

            BEM.MODEL.on( 'm-money-transfer-campaign-from' , 'isDisabled', 'change', function(e, data) {
                this._getRowView(e.target.model.id).disabledChangeHandler(e, data);
            }, this)

            BEM.MODEL.on( 'm-money-transfer-campaign-from' , 'amount', 'change', function(e, data) {
                this._getRowView(e.target.model.id).amountChangeHandler(e, data);
            }, this)

            /*
            * Слушаем событие выбора модели в соседнем списке и блокируем модель с тем же ID в своем списке чтобы не допустить
            * переноса с кампании на нее же
            * */
            BEM.MODEL.on('m-money-transfer-campaign-to', 'isReceiving', 'change', function(e, data) {
                e.target.model.get('available') > 0 && this.setCampaignDisableFlag(
                    this.collection.get('campaigns').getById(e.target.model.id),
                    data.value);

            }, this);
        }
    }
});
