BEM.DOM.decl({ block: 'p-transfer-between-campaigns', elem: 'campaigns', modName: 'direction', modVal: 'to' }, {
    onSetMod: {
        js: function() {
            /*
            * Текстовки для заголовка таблицы - меняются при изменении типа переноса
            * */
            this.elemTexts = {
                title: [iget2('p-transfer-between-campaigns', 'na-kampaniyu', 'На кампанию'), iget2('p-transfer-between-campaigns', 'na-kampanii', 'На кампании')]
            };

            /*
            * Определяем колбэки для контекстных событий:
            * 1) Обработка потри фокуса с инпута указания суммы - если пользователь вручную указывает сумму переноса
            * 2) Изменение чекбокса - если требуется распределить сумму поровну между указанными кампаниями
            * 3) Клик по ссылки групповой выборки
            * */
            this.callbacks = {
                inputBlur: function(id, val) {
                    var campsWithEqualReceive = this.collection.getCampaignsWithEqualReceive();

                    campsWithEqualReceive.length ?
                        this.collection.setAllCampsAmount(campsWithEqualReceive, val) :
                        this.collection.setOneCampAmount(this.collection.get('campaigns').getById(id), val);
                },
                checkboxChange: function(id, isChecked) {
                    if (!this.hasMod('processing')) {
                        var model = this.collection.get('campaigns').getById(id);

                        !isChecked && this.collection.setOneCampAmount(model, 0);
                        this.collection.setOneCampEqualReceive(model, isChecked);

                        this.collection.setAllCampsEqualReceive(
                            this.collection.get('campaigns'),
                            !!this.collection.get('campaigns').where({ isEqualReceive: true }).length)
                    }
                },
                selectAll: function() {
                    this.setMod('processing', 'yes');
                    this.collection.allocateSumEqually();
                    this.delMod('processing');
                }
            };

            this.__base.apply(this, arguments);

            /*
            * Слушаем события коллекции и изменению передаваемой к переносу суммы
            * (не фактически переносимую, а доступную к переносу).
            * Это нужно при изменении кампании с которой планируется перенос в режиме с одной на несколько,
            * когда на момент выбора кампании еще неизвестна сумма переноса
            *
            * Также слушаем изменение кол-ва кампаний отмеченных к разному переносу
            * По обоим событиям обновляем суммы переноса у выбранных кампаний
            * */
            this.collection
                .on('numOfEqualReceivingCampaigns', 'change', this._refreshAmounts, this)
                .on('receivingSum', 'change', function() {
                    this._refreshAmounts();
                }, this)

            /*
            * В качестве оптимизация делегируем отлов событий моделей кампаний списку
            * Слушаем изменение поля модели и вызываем метод представления кампании для обновления UI.
            * методы определяются в модифицированном p-transfer-between-campaigns__campaign */
            BEM.MODEL.on( 'm-money-transfer-campaign-to' , 'isDisabled', 'change', function(e, data) {
                this._getRowView(e.target.model.id).disabledChangeHandler(e, data);
            }, this)

            BEM.MODEL.on( 'm-money-transfer-campaign-to' , 'isReceiving', 'change', function(e, data) {
                this._getRowView(e.target.model.id).receivingChangeHandler(e, data);
            }, this)

            BEM.MODEL.on( 'm-money-transfer-campaign-to' , 'isEqualReceive', 'change', function(e, data) {
                this._getRowView(e.target.model.id).equalReceiveChangeHandler(e, data);
            }, this);

            BEM.MODEL.on( 'm-money-transfer-campaign-to' , 'isEqualReceiveMode', 'change', function(e, data) {
                this._getRowView(e.target.model.id).equalReceiveModeChangeHandler(e, data)
            }, this)

            BEM.MODEL.on( 'm-money-transfer-campaign-to' , 'amount', 'change', function(e, data) {
                this._getRowView(e.target.model.id).amountChangeHandler(e, data);
            }, this)

            /*
            * Слушаем событие выбора модели в соседнем списке и блокируем модель с тем же ID в своем списке чтобы не допустить
            * переноса с кампании на нее же
            * */
            BEM.MODEL.on('m-money-transfer-campaign-from', 'isTransferring', 'change', function(e, data) {
                this.setCampaignDisableFlag(
                    this.collection.get('campaigns').getById(e.target.model.id),
                    data.value);
            }, this)
        }
    },

    /**
     * Обновляет amount моделей
     * Если на элементе не установлен модификатор processing
     * Группирует кампании по флагу isEqualReceive. isEqualReceive ? campsToAllocate : campsToReset
     * Если в коллекции есть модели с указанным флагом, сбрасывает модели массива campsToReset
     * Распределяет сумму переноса поровну между кампаниями массива campsToAllocate
     * @private
     */
    _refreshAmounts: function() {
        if (!this.hasMod('processing')) {
            var camps = this.collection.get('campaigns').reduce(function(result, camp) {
                if (!camp.get('isDisabled')) {
                    camp.get('isEqualReceive') ? result.campsToAllocate.push(camp) : result.campsToReset.push(camp);
                }

                return result;
            },{ campsToAllocate: [], campsToReset: [] });

            if (camps.campsToAllocate.length) {
                this.collection.allocateSumEqually(camps.campsToAllocate);
                this.collection.resetCampaigns(camps.campsToReset);
            }
        }
    }
});
