block('p-transfer-between-campaigns').elem('campaigns')(

    addJs()(true),

    content()(function() {
        var formatedCurrency = u.currencies.getName(this.data.work_currency);

        return [
            {
                elem: 'campaigns-heading',
                content: this.elemMods.direction == 'from' ?
                    this.elemMods['selection-mode'] == 'multi' ? iget2('p-transfer-between-campaigns', 's-kampaniy', 'С кампаний') : iget2('p-transfer-between-campaigns', 's-kampanii', 'С кампании') :
                    this.elemMods['selection-mode'] == 'multi' ? iget2('p-transfer-between-campaigns', 'na-kampanii', 'На кампании') : iget2('p-transfer-between-campaigns', 'na-kampaniyu', 'На кампанию')
            },
            {
                elem: 'campaigns-table-list',
                content: [
                    {
                        elem: 'campaigns-table-list-head',
                        content: {
                            elem: 'campaigns-table-list-headrow',
                            content: [
                                {
                                    name: 'data',
                                    data: [
                                        {
                                            name: 'cid',
                                            title: iget2('p-transfer-between-campaigns', 'no', '№'),
                                            sorted: 'asc'
                                        },
                                        {
                                            name: 'status',
                                            title: iget2('p-transfer-between-campaigns', 'sostoyanie', 'Состояние')
                                        },
                                        {
                                            name: 'name',
                                            title: iget2('p-transfer-between-campaigns', 'kampaniya-105', 'Кампания')
                                        },
                                        {
                                            name: 'remaining',
                                            title: iget2('p-transfer-between-campaigns', 'ostalos', 'Осталось')
                                        }
                                    ].map(function(field) {
                                        return {
                                            elem: 'campaigns-sort-link',
                                            content: {
                                                block: 'link',
                                                content: field.title
                                            },
                                            elemMods: {
                                                type: field.name,
                                                'sort-direction': field.sorted || ''
                                            }
                                        };
                                    })
                                },
                                {
                                    name: 'available',
                                    data: {
                                        elem: 'campaigns-sort-link',
                                        elemMods: { type: 'available' },
                                        content: {
                                            block: 'link',
                                            content: iget2('p-transfer-between-campaigns', 'dostupno', 'Доступно') + ' ' + formatedCurrency
                                        }
                                    }
                                },
                                {
                                    name: 'remaining',
                                    data: {
                                        elem: 'campaigns-sort-link',
                                        elemMods: { type: 'remaining' },
                                        content: {
                                            block: 'link',
                                            content: iget2('p-transfer-between-campaigns', 'ostalos', 'Осталось') + ' ' + formatedCurrency
                                        }
                                    }
                                },
                                {
                                    name: 'transfer',
                                    data: {
                                        elem: 'campaigns-table-list-sub-title',
                                        content: iget2('p-transfer-between-campaigns', 'perenesti', 'Перенести') + ' ' + formatedCurrency
                                    }
                                },
                                {
                                    name: 'all',
                                    data: {
                                        elem: 'campaigns-table-list-sub-title',
                                        content: this.elemMods.direction == 'from' ? iget2('p-transfer-between-campaigns', 'vse', 'Все') : iget2('p-transfer-between-campaigns', 'porovnu', 'Поровну')
                                    }
                                }
                            ].map(function(cell) {
                                return {
                                    elem: 'campaigns-table-list-cell',
                                    elemMods: { type: cell.name },
                                    content: {
                                        elem: 'campaigns-table-list-txt',
                                        elemMods: { type: cell.name },
                                        content: cell.data
                                    }
                                };
                            }, this)
                        }
                    },
                    {
                        elem: 'campaigns-table-list-body',
                        content: this.ctx.campaigns.map(function(camp, i) {
                            return {
                                elem: 'campaign',
                                campaign: camp,
                                elemMods: {
                                    direction: this.elemMods.direction,
                                    'selection-mode': this.elemMods['selection-mode'],
                                    disabled: (this.elemMods.direction == 'from' && camp.available <= 0) ? 'yes' : ''
                                }
                            };
                        }, this)
                    },
                    {
                        elem: 'campaigns-table-list-foot',
                        content: [
                            {
                                elem: 'campaigns-search',
                                content: {
                                    block: 'input',
                                    mix: {
                                        block: 'p-transfer-between-campaigns',
                                        elem: 'campaigns-search-box'
                                    },
                                    placeholder: iget2('p-transfer-between-campaigns', 'nayti-kampaniyu', 'Найти кампанию'),
                                    content: [
                                        {
                                            elem: 'control'
                                        }
                                    ]
                                }
                            },
                            {
                                elem: 'campaigns-links',
                                content: {
                                    elem: 'all',
                                    content: [
                                        {
                                            block: 'link',
                                            mix: {
                                                block: 'p-transfer-between-campaigns',
                                                elem: 'select-all-link',
                                                elemMods: {
                                                    'select-action': 'select'
                                                }
                                            },
                                            content: this.elemMods.direction == 'to' ?
                                                iget2('p-transfer-between-campaigns', 'vybrat-vse', 'выбрать все') : iget2('p-transfer-between-campaigns', 'perenesti-vse', 'перенести все'),
                                            mods: {
                                                pseudo: 'yes'
                                            }
                                        },
                                        {
                                            block: 'link',
                                            mix: {
                                                block: 'p-transfer-between-campaigns',
                                                elem: 'clear-all-link'
                                            },
                                            content: iget2('p-transfer-between-campaigns', 'ochistit-vse', 'очистить все'),
                                            mods: {
                                                pseudo: 'yes'
                                            }
                                        }
                                    ]
                                }
                            },
                            {
                                elem: 'clear'
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
