BEM.DOM.decl({ block: 'p-transfer-between-campaigns', elem: 'campaigns' }, {
    onSetMod: {
        js: function() {

            this.collection = BEM.MODEL.getOne(
                ({ to: 'm-money-transfer-to', from: 'm-money-transfer-from' })[this.getMod('direction')]);

            this.title = this.elem('campaigns-heading');
            this.toggleAllLink = this.findBlockOn('select-all-link', 'link');
            this.clearAllLink = this.findBlockOn('clear-all-link', 'link');
            this.searchBox = this.findBlockOn('campaigns-search-box', 'input');

            this.itemViews = this.elemInstances('campaign');
            this.itemViewsPairs = this.itemViews.reduce(function(pairs, block) {
                pairs[block.model.id] = block;
                return pairs;
            }, {});

            this.on('transferModeChange', this._onTransModeChangeHandler, this)
                .bindTo('campaigns-sort-link', 'click', this._onSortClickHandler)
                .bindTo('campaign', 'click', this._onCampaignClickHandler);

            this.debouncedonSearchHandler = $.debounce(this._onSearchBoxChangeHandler, 300);

            this.searchBox.on('change', this.debouncedonSearchHandler, this);
            this.toggleAllLink.on('click', this._onSelectAllClickHandler, this);
            this.clearAllLink.on('click', this._onClearAllClickHandler, this);

            this.hltHTML = BEMHTML.apply({
                block: 'p-transfer-between-campaigns',
                elem: 'hlt',
                tag: 'span',
                content: '%STR%'
            });
        },

        'selection-mode': function(mod, val) {
            BEM.DOM.update(
                this.title,
                val == 'single' ? this.elemTexts.title[0] : this.elemTexts.title[1]
            );
        }
    },

    onElemSetMod: {
        'campaigns-sort-link': {
            'sort-direction': function(elem, mod, val) {
                BEM.DOM.update(
                    this.findElem(elem, 'sort-direction-icon'),
                    !val ? '' : val == 'asc' ? '▲' : '▼');

            }
        }
    },
    /**
     * Возвращает элемент представления единичной кампании (p-transfer-between-campaigns_campaign)
     * @param {Number} id - id модели
     */
    _getRowView: function(id) {
        return this.itemViewsPairs[id];
    },

    /**
     * Обновляет значение флага isDisabled модели
     * @param {Object} model - изменяемая модель
     * @param {Boolean} val - значение флага
     */
    setCampaignDisableFlag: function(model, val) {
        model && model.set('isDisabled', val);
    },

    /**
     * Обработчик клика по строке таблицы
     * Срабатывает если таблица в режиме single переноса
     * Сбрасывает ранее выбранные кампании и выбирает кампанию по ID
     * @param {Object} e событие
     * @private
     */
    _onCampaignClickHandler: function(e) {
        if (this.hasMod('selection-mode', 'single')) {
            this.collection.resetCampaigns();
            this.collection.selectOneCamp(
                this.collection.get('campaigns').getById(this.elemInstance(e.data.domElem).params.cid));
        }
    },

    /**
     * Обработчик click ссылки сортировки
     * Обновляет состояние ссылки (_toggleSortDirectionIcon)
     * и сортирует элементы списка (_orderCampaigns)
     * @param {Object} e событие
     * @private
     */
    _onSortClickHandler: function(e) {
        var el = e.data.domElem;

        this._orderCampaigns(this.getMod(el, 'type'), this.getMod(el, 'sort-direction'));
        this._toggleSortDirectionIcon(el);
    },

    /**
     * Обработчик события transferModeChange
     * Обновляет модификатор selection-mode и сбрасывает ранее выбранные кампании
     */
    _onTransModeChangeHandler: function() {
        var mode = this.getMod('selection-mode') == 'single' ? 'multi' : 'single';

        this.setMod('selection-mode', mode)
            .setMod(this.toggleAllLink, 'select-action', 'select');

        this.itemViews.forEach(function(view) {
            view.setMod('selection-mode', mode);
        });

        this.collection.resetCampaigns();
    },

    /**
     * Обработчик изменения строки поиска.
     * Обрабатывает полученное значение инпута и вызывает метод поиска _search
     * @param {Object} e событие
     * @private
     */
    _onSearchBoxChangeHandler: function(e) {
        var query = $.trim(u.escapeHTML(e.block.val())).toLowerCase(),
            parts = query.split(/\s+/);

        this.itemViews.forEach(function(el) {
            query.length ?
                el.searchByParts(parts) :
                el.resetView();
        }, this);
    },

    /**
     * Обработчик клик по ссылке "выбрать все/ очистить"
     * Переключает модификатор элемента select-all-link 'deselect' || 'select'
     * вызывает метод выборки модифицированного элемента
     * @private
     */
    _onSelectAllClickHandler: function() {
        this.callbacks.selectAll.call(this);
    },
    /**
     * Обработчик клика по ссылке "очистить все"
     * Сбрасывает все ранее выбранные кампании
     * @private
     */
    _onClearAllClickHandler: function() {
        this.collection.resetCampaigns();
    },

    /**
     * Обновляет иконку ссылки в зависимости от направления сортировки (asc|desc)
     * @param {Object} el Jquery объект ссылки
     * @private
     */
    _toggleSortDirectionIcon: function(el) {
        this.findElem('campaigns-sort-link').not(el).toArray().forEach(function(elem) {
            this.delMod($(elem), 'sort-direction');
        }, this);

        this.setMod(
            el,
            'sort-direction',
            this.hasMod(el, 'sort-direction', 'asc') ? 'desc' : 'asc');
    },

    /**
     * Выполняет сортировку элементов по определенному полю (field) в нужном направлении (direction) (asc|desc)
     * @param {String} field название поля по которому производится сортировка
     * @param {'asc'|'desc'} direction направление поиска
     * @private
     */
    _orderCampaigns: function(field, direction) {
        this.collection.getSortedCampaignList(field, direction).forEach(function(camp, i) {
            this.elem('campaigns-list').prepend(
                this.itemViewsPairs[camp.id].domElem);
        }, this);
    }
}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('change', 'checkbox', function(e) {
                this.callbacks.checkboxChange.call(this, e.block.params.cid, e.block.isChecked());
            }, this)
            .liveInitOnBlockInsideEvent('blur', 'input', function(e) {
                var id = e.block.params.cid,
                    value = e.block.val();

                if (id) {
                    if (value) {
                        value = u.numberFormatter.roundFormatted(u.numberFormatter.clear(value, { fail: 0 }));
                        e.block.val(value);
                    }
                    this.callbacks.inputBlur.call(this, id, value);
                }
            }, this);
    }
});
