block('p-transfer-between-campaigns')(

    elem('title').tag()('h1'),

    elem('links-row').tag()('tr'),

    elem('summary').tag()('table'),

    elem('summary-row').tag()('tr'),

    elem('summary-title').tag()('td'),

    elem('summary-list').tag()('td'),

    elem('summary-sum').tag()('td'),

    elem('summary-form').tag()('form'),

    elem('head-text').tag()('td'),

    elem('campaigns-table-list-cell').tag()('td'),

    elem('campaigns-table-list-row').tag()('tr'),

    elem('campaign').tag()('tr'),

    elem('campaign-name').tag()('span'),

    elem('campaigns-table-list-headrow').tag()('tr'),

    elem('campaigns-table-list-col').tag()('col'),

    elem('campaigns-table-list-colgroup').tag()('colgroup'),

    elem('warning-txt').tag()('span'),

    elem('line-break').tag()('br'),

    elem('campaign-total')(
        tag()('span'),

        content()(function() {
            return ', ' + applyNext();
        })
    ),

    elem('summary-field')(
        tag()('input'),

        attrs()(function() {
            return {
                type: 'hidden',
                name: this.ctx.name,
                value: this.ctx.value
            };
        })
    ),

    elem('campaigns-table-list-inner-table')(
        tag()('table'),

        content()(function() {
            return [
                {
                    elem: 'campaigns-table-list-colgroup',
                    content: ['data', 'available', 'remaining', 'input', 'checkbox'].map(function(field) {
                        return {
                            elem: 'campaigns-table-list-col',
                            elemMods: { field: field }
                        }
                    })
                },
                applyNext()
            ];
        })
    ),

    elem('campaigns-table-list-head').content()(function() {
        return {
            elem: 'campaigns-table-list-wrap',
            content: [
                { elem: 'campaigns-table-list-hider' },
                {
                    elem: 'campaigns-table-list-inner-table',
                    content: applyNext()
                }
            ]
        };
    }),

    elem('campaigns-table-list-body').content()(function() {
        return {
            elem: 'campaigns-table-list-inner-table',
            mix: {
                block: 'p-transfer-between-campaigns',
                elem: 'campaigns-list'
            },
            content: applyNext()
        };
    }),

    elem('campaigns-sort-link').content()(function() {
        return [
            applyNext(),
            {
                elem: 'sort-direction-icon',
                tag: 'span'
            }
        ];
    })
);
