match(function() {
    return this.data.cmd === 'transfer';
})(

    block('app-main').mode('page-block')({
        block: 'p-transfer-between-campaigns',
        mods: {
            'selection-mode': 'multi'
        }
    }),

    block('b-page').mode('title')(function() {
        return iget2('p-transfer-between-campaigns', 'perenos-sredstv', 'Перенос средств');
    })
);

block('p-transfer-between-campaigns')(

    def()(function() {
        var data = this.data,
            currency = u.currencies.getName(data.work_currency),
            getCampaignStatus = function(campaign) {
                var status = '',
                    finished = campaign.finished,
                    show = campaign.statusShow == 'Yes',
                    notBsSynced = campaign.statusBsSynced != 'Yes',
                    notNew = campaign.statusModerate != 'New';

                if (!finished && show && notNew && notBsSynced) {
                    status = 'activating';
                } else if (!finished && show && notNew) {
                    status = (campaign.sum - campaign.sum_spent == 0) ? 'no-money' : 'active';
                } else if ((!show && campaign.stopping) || (finished && notBsSynced)) {
                    status = 'stopping';
                } else {
                    status = 'stop';
                }

                return status;
            },
            campaignsFromModel = data.campaigns_from.map(function(campaign) {
                return {
                    cid: campaign.cid,
                    name: campaign.name,
                    remaining: parseFloat(campaign.total).toFixed(2),
                    available: parseFloat(campaign.sum_available).toFixed(2),
                    amount: 0,
                    status: getCampaignStatus(campaign),
                    agencyid: parseInt(campaign.AgencyID),
                    isDisabled: campaign.sum_available > 0 ? false : true,
                    isTransferring: false,
                    transferAll: false,
                    mediaType: campaign.mediaType
                };
            }),
            campaignsToModel = data.campaigns_to.map(function(campaign) {
                return {
                    cid: campaign.cid,
                    name: campaign.name,
                    remaining: parseFloat(campaign.total).toFixed(2),
                    available: parseFloat(campaign.sum_available).toFixed(2),
                    amount: 0,
                    status: getCampaignStatus(campaign),
                    agencyid: parseInt(campaign.AgencyID),
                    isDisabled: false,
                    isReceiving: false,
                    isEqualReceiveMode: false,
                    isEqualReceive: false
                };
            });

        return applyNext({
            campaignsFromModel: campaignsFromModel,
            campaignsToModel: campaignsToModel,
            formattedCurrency: currency,
            showFullPage: !!data.campaigns_from.length && !!data.campaigns_to.length,
            error: data.FORM.error,
            isCampaignsNotEmpty: campaignsFromModel.length && campaignsToModel.length
        });
    }),

    addJs()(function() {
        return {
            currency: this.data.work_currency,
            customMinTransferMoney: this.data.customMinTransferMoney,
            error: this.error
        };
    }),

    content()(function() {
        return {
            block: 'l-page',
            mods: { layout: '8-72' },
            content: {
                elem: 'row',
                right: [
                    {
                        block: 'p-transfer-between-campaigns',
                        elem: 'header',
                        content: [
                            {
                                elem: 'title',
                                content: iget2('p-transfer-between-campaigns', 'perenesti-sredstva', 'Перенести средства')
                            },
                            !!this.error && {
                                block: 'p-transfer-between-campaigns',
                                elem: 'error',
                                content: u.escapeHTML(this.error)
                            },
                            {
                                elem: 'sub-header',
                                content: [
                                    this.showFullPage ?
                                        {
                                            elem: 'switcher'
                                        } :
                                        {
                                            block: 'p-transfer-between-campaigns',
                                            elem: 'notification',
                                            content: iget2(
                                                'p-transfer-between-campaigns',
                                                'net-oplachennyh-reklamnyh-kampaniy',
                                                'Нет оплаченных рекламных кампаний, доступных для переноса средств'
                                            )
                                        },
                                    {
                                        elem: 'note',
                                        content: [
                                            {
                                                block: 'icon',
                                                mods: {
                                                    'size-13': 'alert'
                                                },
                                                mix: [{
                                                    block: 'p-transfer-between-campaigns',
                                                    elem: 'notice-icon'
                                                }]
                                            },
                                            {
                                                elem: 'warning-txt',
                                                content: iget2('p-transfer-between-campaigns', 'perenesti-mozhno-tolko-dostupnuyu', 'Перенести можно только доступную к переносу сумму')
                                            },
                                            {
                                                block: 'b-help-link',
                                                mods: { type: 'modal' },
                                                mix: {
                                                    block: 'p-transfer-between-campaigns',
                                                    elem: 'note-icon'
                                                },
                                                url: u.getHelpUrl('transferring'),
                                                width: '70%'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    },
                    !!this.data.campaigns_from.length && {
                        block: 'p-transfer-between-campaigns',
                        elem: 'campaigns',
                        campaigns: this.campaignsFromModel,
                        elemMods: {
                            direction: 'from',
                            'selection-mode': 'multi'
                        }
                    },
                    !!this.data.campaigns_to.length && {
                        block: 'p-transfer-between-campaigns',
                        elem: 'campaigns',
                        campaigns: this.campaignsToModel,
                        elemMods: {
                            direction: 'to',
                            'selection-mode': 'single'
                        }
                    },
                    !!this.showFullPage && {
                        block: 'p-transfer-between-campaigns',
                        elem: 'footer'
                    }
                ]
            }
        };
    })
);
