BEM.DOM.decl('p-transfer-between-campaigns', {
    onSetMod: {
        js: function() {

            this.confirm = BEM.blocks['b-confirm'];
            this.form = this.elem('summary-form');
            this.swither = this.findBlockInside('switcher', 'radiobox');

            this.minTransferMoney = this.params.customMinTransferMoney || u.currencies.getConst(this.params.currency, 'MIN_TRANSFER_MONEY');

            this.models = {
                from: BEM.MODEL.create({
                    id: 'from',
                    name: 'm-money-transfer-from'
                }, {}),
                to: BEM.MODEL.create({
                    id: 'to',
                    name: 'm-money-transfer-to'
                }, {})
            };

            this.campaignsListViews = {
                from: this.elemInstance(this.elem('campaigns', 'direction', 'from')),
                to: this.elemInstance(this.elem('campaigns', 'direction', 'to'))
            };

            this.summary = {
                campsTitle: {
                    from: this.elem('summary-title', 'type', 'source'),
                    to: this.elem('summary-title', 'type', 'destination')
                },
                campsList: {
                    from: this.elem('summary-list', 'type', 'source'),
                    to: this.elem('summary-list', 'type', 'destination')
                },
                campsFields: {
                    from: this.elem('summary-camps-fields','direction', 'from'),
                    to: this.elem('summary-camps-fields', 'direction', 'to')
                },
                spinner: this.findBlockInside('spin'),
                sum: this.elem('summary-sum')
            };

            this.swither && this.swither.on('change', function(e) {
                this.setMod('selection-mode', e.block.val());
            }, this);

            this.bindTo('submit-button', 'click', this._onSubmitClick);

            /*
            * в качестве оптимизации дебоунсим обработчики чтобы избежать лишних перерисовок при групповых выборках
            * в списках кампаний
            * */
            var debounceHandler = function(fn) {
                    return $.debounce(fn, 50, this);
                }.bind(this),
                debouncedHandlers = {
                    srcModelAmountChange: debounceHandler(function() {
                        var campaigns = this.models.from.getTransferringCampaigns();

                        this._updateSum(campaigns);

                        this.models.to.update({
                            receivingSum: this.models.from.getSumOfAvailableValue(campaigns)
                        });
                    }),
                    destModelAmountChange: debounceHandler(function() {
                        this._updateSum(this.models.to.getReceivingCampaigns());
                    }),
                    srcModelFlagChange: debounceHandler(function() {
                        var campaigns = this.models.from.getTransferringCampaigns();

                        this._updateList('from', campaigns);

                        this.models.to.update({
                            receivingSum: this.models.from.getSumOfAvailableValue(campaigns),
                            numOfTransferringCamps: campaigns.length
                        });
                    }),
                    destModelFlagChange: debounceHandler(function() {
                        this._updateList('to', this.models.to.getReceivingCampaigns());
                    })
                };

            BEM.MODEL
                .on('m-money-transfer-campaign-from',
                    'amount',
                    'change',
                    debouncedHandlers.srcModelAmountChange, this)
                .on('m-money-transfer-campaign-from',
                    'isTransferring',
                    'change',
                    debouncedHandlers.srcModelFlagChange, this)
                .on('m-money-transfer-campaign-to',
                    'amount',
                    'change',
                    debouncedHandlers.destModelAmountChange, this)
                .on('m-money-transfer-campaign-to',
                    'isReceiving',
                    'change',
                    debouncedHandlers.destModelFlagChange, this);
        },

        'selection-mode': function(name, val) {
            $.each(this.campaignsListViews, function(key, el) {
                el.trigger('transferModeChange', val);
            });
            this._resetSummary();
            this._updateSummaryTitles(val);
        }
    },

    /**
     * Обработчик click кнопки "Перенести средства".
     * Поверяет поля моделей на соответствие условиям - если ошибок нет запрос отправляется,
     * иначе модальное окно с текстом ошибки.
     * @private
     */
    _onSubmitClick: function() {
        this._updateHiddenInputs();

        var error = this._validate();

        if (error) {
            this.confirm.open({
                message: error,
                type: 'alert'
            });
        } else {
            this.findBlockInside('summary-spin', 'spin').setMod('progress', 'yes');

            this.setMod(this.elem('submit-button'), 'hidden', 'yes')
                .delMod(this.elem('summary-spin'), 'hidden');

            this.form.submit();
        }
    },

    /**
     * Обновляет список кампаний в элементе summary-camps-fields .
     * Обновляет сумму переноса в элементе summary-sum
     * @param {'from'|'to'} direction направление переноса средств
     * @param {Array} campaigns массив кампаний
     * @private
     */
    _updateList: function(direction, campaigns) {
        var isDestList = direction == 'to',
            isSingleMode = this.hasMod('selection-mode', 'single');

        BEM.DOM.update(this.summary.campsList[direction], BEMHTML.apply([
            {
                block: 'p-transfer-between-campaigns',
                elem: 'summary-camps-list',
                content: campaigns.length ?
                    campaigns.map(function(item, i) {
                        return item.get('name') + ' (' + iget2('p-transfer-between-campaigns', 'no', '№') + item.get('cid') + ')' +
                            (campaigns.length - 1 == i ? '' : ', ');
                    }) :
                    '&mdash;'
            },
            {
                block: 'p-transfer-between-campaigns',
                elem: 'summary-camps-count',
                content:
                    ((isDestList && isSingleMode) || (!isDestList && !isSingleMode)) && campaigns.length ?
                        '(' + campaigns.length + ')' :
                        ''
            }
        ]));
    },

    /**
     * Обновляет набор скрытых полей в форме.
     * Метод вызывается при валидации и обновляет список скрытых полей.
     * Набор полей формируется в зависимости от модификатора selection-mode
     * @private
     */
    _updateHiddenInputs: function() {
        var transferringCamp = this.models.from.getTransferringCampaigns(),
            receivingCamps = this.models.to.getReceivingCampaigns(),
            transferMode = this.getMod('selection-mode');

        BEM.DOM.update(
            this.summary.campsFields.from,
            BEMHTML.apply(transferringCamp.map(function(camp) {
                return transferMode == 'single' ?
                    ['transfer_from', 'transfer-from-radio'].map(function(name) {
                        return {
                            block: 'p-transfer-between-campaigns',
                            elem: 'summary-field',
                            name: name,
                            value: camp.id
                        };
                    }) :
                    {
                        block: 'p-transfer-between-campaigns',
                        elem: 'summary-field',
                        name: 'from__' + camp.id,
                        value: camp.get('amount')
                    }
            }))
        );

        BEM.DOM.update(
            this.summary.campsFields.to,
            BEMHTML.apply(receivingCamps.map(function(camp) {
                return transferMode == 'multi' ?
                    ['transfer_to', 'transfer-to-radio'].map(function(name) {
                        return {
                            block: 'p-transfer-between-campaigns',
                            elem: 'summary-field',
                            name: name,
                            value: camp.id
                        };
                    }) :
                    {
                        block: 'p-transfer-between-campaigns',
                        elem: 'summary-field',
                        name: 'to__' + camp.id,
                        value: camp.get('amount')
                    }
            }))
        );

    },

    /**
     * Обновляет сумму переноса в элементе 'summary-sum'.
     * @param {Array} campaigns массив кампаний
     * @private
     */
    _updateSum: function(campaigns) {
        var total = campaigns.reduce(function(sum, camp) {
            if (camp.get('amount') > 0) {
                sum += camp.get('amount');
            }

            return sum;
        }, 0);

        BEM.DOM.update(
            this.summary.sum,
            total > 0 ?
                u.numberFormatter.format(total) + ' ' + u.currencies.getName(this.params.currency) :
                '&mdash;');
    },

    /**
     * Переключает заголовки в summary "С кампании" / "С кампаний"  и "На кампании" / "На кампанию".
     * в зависимости от текущей формы переноса
     * @param {String} mode тип переноса
     * @private
     */
    _updateSummaryTitles: function(mode) {

        BEM.DOM.update(this.summary.campsTitle.from, mode == 'multi' ? iget2('p-transfer-between-campaigns', 's-kampaniy', 'С кампаний') : iget2('p-transfer-between-campaigns', 's-kampanii', 'С кампании'));

        BEM.DOM.update(this.summary.campsTitle.to , mode == 'multi' ? iget2('p-transfer-between-campaigns', 'na-kampaniyu', 'На кампанию') : iget2('p-transfer-between-campaigns', 'na-kampanii', 'На кампании'));
    },

    /**
     * Сбрасывает summary , списки и сумму переноса
     * @private
     */
    _resetSummary: function() {
        BEM.DOM.update(this.summary.campsList.to, BEMHTML.apply([
            {
                block: 'p-transfer-between-campaigns',
                elem: 'summary-camps-list',
                content: '&mdash;'
            },
            {
                block: 'p-transfer-between-campaigns',
                elem: 'summary-camps-count',
                content: ''
            }
        ]));

        BEM.DOM.update(this.summary.campsList.from, BEMHTML.apply([
            {
                block: 'p-transfer-between-campaigns',
                elem: 'summary-camps-list',
                content: '&mdash;'
            },
            {
                block: 'p-transfer-between-campaigns',
                elem: 'summary-camps-count',
                content: ''
            }
        ]));

        BEM.DOM.update(this.summary.sum, '&mdash;');
    },

    /**
     * Проверяем модели на соответствие условиям.
     * @returns {String} текст ошибки или пустая строка.
     * @private
     */
    _validate: function() {
        /*
        *   1) если не выбраны кампании с которых не выполняется перенос
        *   2) если не выбраны кампании на которые выполняется перенос
        *   3) если номер кампании с которой переносим равен номеру кампании на которую переносим
        *
        *   4) если на кампании остается меньше средств чем сумма переноса
        *   5) если переносим с кампании меньше минимальной суммы
        *      - с остановленной переносим либо все либо более минимальной
        *      - с общего счета все или более минимальной, если все остальные остановлены
        *   6) если переносим с кампании меньше минимальной суммы с учетом бонуса
        *
        *   7) если переводим на кампанию сумму меньше минимальной
        *   8) если переводим на кампанию сумму меньше минимальной с учетом бонуса
        *   9) если кампания на которую переносим принадлежит другому агентству
        * */

        var error = '',
            transferType = this.getMod('selection-mode'),
            minSumFormated = u.currencies.formatSum(this.params.currency, this.minTransferMoney),
            transferringCampaigns = this.models.from.getTransferringCampaigns(),
            receivingCampaigns = this.models.to.getReceivingCampaigns(),
            transferringSumm = transferringCampaigns.reduce(function(memo, item) {
                return (memo += item.get('amount'))
            }, 0),
            receivingSumm = receivingCampaigns.reduce(function(memo, item) {
                return (memo += item.get('amount'))
            }, 0),
            receivingCampaignsIds = receivingCampaigns.map(function(c) {
                return c.id
            }),
            isAllNonMediaTypeCampsStopped = transferringCampaigns.filter(function(item) {
                return item.get('mediaType') !== 'wallet'
            }).every(function(item) {
                return item.get('status') == 'stop'
            });

        if (!transferringCampaigns.length) {
            error = iget2(
                'p-transfer-between-campaigns',
                'oshibka-vyberite-kampanii-s',
                'Ошибка: Выберите кампании, с которых хотите перенести средства.'
            );
        } else {
            transferringCampaigns.forEach(function(camp) {

                var trSum = transferType == 'multi' ? camp.get('amount') : receivingSumm;

                if ($.inArray(camp.id, receivingCampaignsIds) != -1) {
                    error = iget2(
                        'p-transfer-between-campaigns',
                        'oshibka-nevozmozhno-perenesti-sredstva',
                        'Ошибка: Невозможно перенести средства с кампании № {foo} на нее же.',
                        {
                            foo: camp.id
                        }
                    );
                }

                if (camp.get('status') == 'stop' || (camp.get('mediaType') == 'wallet' &&
                    camp.get('status') !== 'stop' && isAllNonMediaTypeCampsStopped)) {

                    if (camp.get('available') !== trSum && trSum < this.minTransferMoney ) {
                        error = iget2(
                            'p-transfer-between-campaigns',
                            'oshibka-perevod-s-kampanii',
                            'Ошибка: Перевод с кампании № {foo} возможен на сумму не менее {bar}',
                            {
                                foo: camp.id,
                                bar: minSumFormated
                            }
                        );
                    }
                } else {
                    if (trSum < this.minTransferMoney) {
                        error = iget2(
                            'p-transfer-between-campaigns',
                            'oshibka-perevod-s-kampanii',
                            'Ошибка: Перевод с кампании № {foo} возможен на сумму не менее {bar}',
                            {
                                foo: camp.id,
                                bar: minSumFormated
                            }
                        );
                    }

                    if (transferType == 'single') {
                        if (camp.get('available') < receivingSumm) {
                            error = iget2(
                                'p-transfer-between-campaigns',
                                'oshibka-ostatok-sredstv-na',
                                'Ошибка: Остаток средств на кампании № {foo} не может быть меньше {bar} {baz}',
                                {
                                    foo: camp.id,
                                    bar: u.formatPrice(camp.get('remaining') - camp.get('available')),
                                    baz: u.currencies.getName(this.params.currency)
                                }
                            );
                        }
                    }
                }
            }, this);
        }

        if (!error) {
            if (!receivingCampaigns.length) {
                error = iget2(
                    'p-transfer-between-campaigns',
                    'oshibka-vyberite-kampanii-na',
                    'Ошибка: Выберите кампании, на которые хотите перенести средства.'
                );
            } else {

                var trCamp = {
                    type: transferringCampaigns[0].get('mediaType'),
                    status: transferringCampaigns[0].get('status'),
                    available: transferringCampaigns[0].get('available')
                };

                receivingCampaigns.forEach(function(camp) {
                    var toAgencyId = camp.get('agencyid'),
                        amountSum = transferType == 'multi' ? transferringSumm : camp.get('amount');

                    if ((trCamp.status !== 'stop' && trCamp.type == 'wallet') && isAllNonMediaTypeCampsStopped) {
                        if (amountSum !== trCamp.available && amountSum < this.minTransferMoney ) {
                            return error = iget2(
                                'p-transfer-between-campaigns',
                                'oshibka-perevod-na-kampaniyu',
                                'Ошибка: Перевод на кампанию № {foo} возможен на сумму не менее {bar}',
                                {
                                    foo: camp.id,
                                    bar: minSumFormated
                                }
                            );
                        }
                    } else {
                        if (amountSum < this.minTransferMoney && trCamp.status !== 'stop') {
                            return error = iget2(
                                'p-transfer-between-campaigns',
                                'oshibka-perevod-na-kampaniyu',
                                'Ошибка: Перевод на кампанию № {foo} возможен на сумму не менее {bar}',
                                {
                                    foo: camp.id,
                                    bar: minSumFormated
                                }
                            );
                        }
                    }

                    transferringCampaigns.forEach(function(fromCamp) {
                        var fromAgencyId = fromCamp.get('agencyid');

                        if (fromAgencyId != toAgencyId) {
                            if (fromAgencyId && toAgencyId) {
                                error = iget2(
                                    'p-transfer-between-campaigns',
                                    'kampanii-no-s-i',
                                    'Кампании № {foo} и № {bar} принадлежат разным агентствам. Перенос средств возможен только на кампанию того же агентства.',
                                    {
                                        foo: fromCamp.id,
                                        bar: camp.id
                                    }
                                )
                            } else if (!toAgencyId) {
                                error = iget2(
                                    'p-transfer-between-campaigns',
                                    'perenos-s-kampanii-no',
                                    'Перенос с кампании № {foo} на № {bar} невозможен. Перенести средства с этой кампании можно только на кампанию того же агентства.',
                                    {
                                        foo: fromCamp.id,
                                        bar: camp.id
                                    }
                                )
                            } else {
                                error = iget2(
                                    'p-transfer-between-campaigns',
                                    'perenos-s-kampanii-no-104',
                                    'Перенос с кампании № {foo} на № {bar} невозможен. Перенести средства на эту кампанию возможно только с кампании того же агентства.',
                                    {
                                        foo: fromCamp.id,
                                        bar: camp.id
                                    }
                                )
                            }
                        }
                    }, this);
                }, this);
            }
        }

        return error;
    }
});
