match(function() {
    return this.data.cmd === 'transferStepZero';
})(

    block('app-main')(

        mode('preprocess')(function() {
            var data = this.data;

            //для работы u.currencies
            applyCtx({
                block: 'i-utils',
                elem: 'currencies'
            });

            data.subclients
                .sort(function(a, b) {
                    return a.login.toLowerCase().localeCompare(b.login.toLowerCase());
                })
                .forEach(function(client) {
                    client.formattedSumOfMoney = u.currencies.formatSum(client.work_currency, client.total);
                    client.minPrice = u.currencies.getConst(client.work_currency, 'MIN_PRICE');
                });

            return data;
        }),

        mode('page-block')('p-transfer-between-clients')
    ),

    block('b-page').mode('title')(function() {
        return iget2('p-transfer-between-clients', 'perenos-sredstv', 'Перенос средств');
    })
);

block('p-transfer-between-clients')(

    addJs()(function() {
        return {
            hasMultiCurrencyClients: this.data.has_multicurrency_clients,
            subclients: this.data.subclients
        };
    }),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '6-80-6'
            },
            content: [
                {
                    elem: 'row',
                    center: [
                        {
                            block: 'b-page-title',
                            mix: [{
                                block: 'p-transfer-between-clients',
                                elem: 'page-title'
                            }],
                            content: [
                                {
                                    elem: 'title',
                                    mix: [{
                                        block: 'p-transfer-between-clients',
                                        elem: 'title'
                                    }],
                                    content: iget2('p-transfer-between-clients', 'perenesti-sredstva', 'Перенести средства')
                                },
                                this.data.error && {
                                    block: 'p-transfer-between-clients',
                                    elem: 'errors',
                                    error: this.data.error
                                }
                            ]
                        }
                    ]
                },
                {
                    elem: 'row',
                    center: this.data.subclients.length ?
                        {
                            block: 'b-layout-form',
                            submit: {
                                block: 'p-transfer-between-clients',
                                elem: 'form-submit'
                            },

                            action: this.data.script,

                            hiddenInputs: [
                                {
                                    name: 'cmd',
                                    value: 'transfer'
                                },
                                {
                                    name: 'multiuser',
                                    value: 1
                                },
                                {
                                    name: 'ulogin',
                                    value: this.data.user_login
                                }
                            ],

                            rows: [
                                applyCtx({
                                    block: 'p-transfer-between-clients',
                                    elem: 'form-content',
                                    clients: this.data.subclients
                                })
                            ]
                        } :
                        {
                            block: 'p-transfer-between-clients',
                            elem: 'page-title',
                            content: iget2('p-transfer-between-clients', 'net-klientov', 'Нет клиентов')
                        }
                }
            ]
        };
    }),

    elem('form-content').content()(function() {
        return [
            {
                elem: 'box-select',
                elemMods: {
                    client: 'from'
                },
                clients: this.ctx.clients
            },
            {
                elem: 'box-select',
                elemMods: {
                    client: 'to'
                },
                clients: this.ctx.clients
            }
        ];
    }),

    elem('box-select')(

        elemMod('client', 'from').def()(function() {
            return applyNext({
                'ctx.title': iget2('p-transfer-between-clients', 'ot-klienta', 'от клиента'),
                'ctx.name': 'client_from'
            });
        }),

        elemMod('client', 'to').def()(function() {
            return applyNext({
                'ctx.title': iget2('p-transfer-between-clients', 'k-klientu', 'к клиенту'),
                'ctx.name': 'client_to'
            });
        }),

        content()(function() {
            var ctx = this.ctx,
                name = ctx.name,
                count = 0,
                isFrom = this.elemMods && this.elemMods.client === 'from';

            return [
                {
                    elem: 'box-title',
                    content: ctx.title
                },
                {
                    block: 'select',
                    mods: {
                        type: 'multiline'
                    },
                    mix: [{
                        block: 'p-transfer-between-clients',
                        elem: u.beminize(name)
                    }],
                    name: name,
                    size: 10,
                    content: {
                        elem: 'control',
                        mix: [{
                            block: 'p-transfer-between-clients',
                            elem: 'select-control'
                        }],
                        content: ctx.clients.reduce(function(options, client) {
                            var allow,
                                disabled;

                            if (isFrom) {
                                allow = !client.disallow_money_transfer;

                                allow && client.total < client.minPrice && (disabled = 'yes');
                            } else {
                                allow = !!(client.allowPayCampCount && client.count_non_archived_text_camps);
                            }

                            allow &&
                                options.push({
                                    elem: 'option',
                                    attrs: {
                                        value: client.login,
                                        disabled: disabled
                                    },
                                    content: [
                                        client.login,
                                        ' &ndash; ',
                                        u.escapeHTML(client.fio),
                                        ' (',
                                        client.formattedSumOfMoney,
                                        ')'
                                    ]
                                });

                            count = options.length;

                            return options;
                        }, [])
                    }
                },
                count > 10 && {
                    block: 'input',
                    // будет замиксовано одно из:
                    //  elem: 'filter-client-from'
                    //  elem: 'filter-client-to'
                    mix: [{
                        block: 'p-transfer-between-clients',
                        elem: ('filter-' + u.beminize(name))
                    }],
                    placeholder: iget2('p-transfer-between-clients', 'nayti', 'Найти'),
                    content: [
                        {
                            elem: 'control'
                        }
                    ]
                }
            ];
        })
    ),

    elem('errors').content()(function() {
        var contents = u.escapeHTML(this.ctx.error).split('\n');

        return contents.length && [
            {
                block: 'icon',
                mods: {
                    'size-13': 'alert'
                },
                mix: [{
                    block: 'p-transfer-between-clients',
                    elem: 'notice-icon'
                }]
            },
            {
                elem: 'error-messages',
                content: contents.join('<br />')
            }
        ];
    })
);
