BEM.DOM.decl('p-transfer-between-clients', {

    onSetMod: {
        js: function() {
            this._subclients = this.params.subclients || [];
            this._shownSubclients = this._subclients;

            u.graspSelf.call(this, {
                selectFrom: 'select on client-from',
                selectTo: 'select on client-to',
                submitButton: 'button on submit-button'
            });

            this._filterFrom = this.findBlockOn('filter-client-from', 'input');
            this._filterTo = this.findBlockOn('filter-client-to', 'input');

            this._filterFrom && this._filterFrom.on('change', function(e) {
                this._updateSourceSelectOptions(e.block.val().trim().toLowerCase());
            }, this);

            this._filterTo && this._filterTo.on('change', function(e) {
                this._updateDestinationSelectOptions(e.block.val().trim().toLowerCase());
            }, this);

            this.toggleMod('has-multicurrency-clients', 'yes', !!this.params.hasMultiCurrencyClients);

            this.selectFrom.on('change', this._toggleSubmitButtonState, this);
            this.selectTo.on('change', this._toggleSubmitButtonState, this);

            this.bindTo('submit', function(e) {
                if (this._isSelectedClients()) {
                    this.submitButton.setMod('disabled', 'yes');
                } else {
                    e.preventDefault();

                    BEM.blocks['b-confirm'].alert(iget2('p-transfer-between-clients', 'klienty-ne-vybrany', 'Клиенты не выбраны'));
                }
            });
        },

        'has-multicurrency-clients': function(modName, modVal) {
            var method = modVal ? 'on' : 'un';

            // явным образом следим за выбранной валютой
            this.selectFrom[method]('change', this._updateWorkingCurrency, this);

            // добавление/отключение обработчика события для фильтрации клиентов по валюте
            this.selectFrom[method]('change', function() { this._updateDestinationSelectOptions(); }, this);

            this.workingCurrency = modVal ? this._getWorkingCurrency() : '';

            this._updateDestinationSelectOptions();
        }
    },

    /**
     * Включает/выключает кнопку отправки формы в зависимости от проверки выбранных значений
     * @private
     */
    _toggleSubmitButtonState: function() {
        this.submitButton.toggleMod('disabled', 'yes', !this._isSelectedClients());
    },

    /**
     * Выбраны ли клиенты для осуществления действия?
     * @returns {Boolean}
     * @private
     */
    _isSelectedClients: function() {
        return !!(this.selectFrom.val() && this.selectTo.val());
    },

    /**
     * Обновление значения выбранной валюты
     * @private
     */
    _updateWorkingCurrency: function() {
        this.workingCurrency = this._getWorkingCurrency();
    },

    /**
     * Обновляет список "к клиенту" (фильтрует по выбранному значению в списке "от клиента")
     * @param {String} [filterText] строка для фильтрации по логину или названию
     * @private
     */
    _updateDestinationSelectOptions: function(filterText) {
        var select = this.selectTo,
            selectedLogin = select.val(),
            currency = this.workingCurrency,
            options = this._subclients
                .filter(function(client) {
                    return client.allowPayCampCount &&
                        client.count_non_archived_text_camps &&
                            (!currency || client.work_currency === currency) &&
                                this._checkFilterText(client, filterText);
                }, this)
                .map(function(client) {
                    return this._buildOptionItem(client, client.login === selectedLogin, false, filterText);
                }, this);

        select.setOptions(options);
    },

    /**
     * Обновляет список "от клиента"
     * @param {String} [filterText] строка для фильтрации по логину или названию
     * @private
     */
    _updateSourceSelectOptions: function(filterText) {
        var select = this.selectFrom,
            selectedLogin = select.val(),
            shownSubclients = [],
            options = this._subclients
                .filter(function(client) {
                    return !client.disallow_money_transfer && this._checkFilterText(client, filterText);
                }, this)
                .map(function(client) {
                    shownSubclients.push(client);

                    return this._buildOptionItem(
                        client,
                        client.login === selectedLogin,
                        client.total < client.minPrice,
                        filterText
                    );
                }, this);

        this._shownSubclients = shownSubclients;
        select.setOptions(options);
    },

    /**
     * Проверяет необходимость отфильтровать данные
     * @param {Object} client данные для option элемента select
     * @param {String} [filterText] строка для фильтрации по логину или названию
     * @returns {Boolean}
     * @private
     */
    _checkFilterText: function(client, filterText) {
        return !filterText || filterText.split(/\s+/).some(function(part) {
            return client.login.toLowerCase().indexOf(part) > -1 ||
                client.fio.toLowerCase().indexOf(part) > -1;
        });
    },

    /**
     * Строит bemjson для элемента option для select
     * @param {Object} client данные для option элемента select
     * @param {Boolean} selected выбран или нет option элемент
     * @param {Boolean} disabled заблокирован или нет option элемент
     * @param {String} [filterText] строка для фильтрации по логину или названию
     * @returns {Object}
     * @private
     */
    _buildOptionItem: function(client, selected, disabled, filterText) {
        var texts = {
                login: client.login,
                fio: client.fio
            },
            filterRegExp,
            highlight,
            highlightFioText = [],
            highlightStartIndex,
            prevEnd = 0;

        if (filterText) {
            filterRegExp = filterText &&
                new RegExp('(' + u.escape.regExp(filterText).split(/\s+/).join('|') + ')', 'ig');

            highlight = this._highlightHTML || (this._highlightHTML = BEMHTML.apply({
                block: 'p-transfer-between-clients',
                elem: 'highlight'
            }));

            ['login', 'fio'].forEach(function(field) {
                texts[field] = texts[field].replace(filterRegExp, function(content) {
                    if (field == 'fio') {
                        // для DIRECT-64115
                        // идея - сохранить в массив все html вставки,
                        // а в итоговой строке заэскейпить все кроме них.
                        // эскейпить строку до поиска - нельзя,
                        // т. к. тогда нестабильно работает поиск
                        var item = highlight.replace('%s', u.escapeHTML(content));
                        highlightFioText.push(item);
                        return item;
                    } else {
                        return highlight.replace('%s', content);
                    }
                });
            });
        }

        // для DIRECT-64115
        if (highlightFioText.length > 0) {
            highlightFioText.forEach(function(text, i, arr) {
                var prevFioLength = texts.fio.length;

                // вычисляем начало html-вставки
                highlightStartIndex = texts.fio.indexOf(text, prevEnd);
                // в строку сохраняем =
                //  просмотренный участок строки
                //  эскейпим непросмотренный участок до начала html-вставки
                //  остальной участок строки с html-вставкой
                texts.fio =
                    texts.fio.substr(0, prevEnd) +
                    u.escapeHTML(texts.fio.substring(prevEnd, highlightStartIndex)) +
                    texts.fio.substr(highlightStartIndex);

                // новое значение для индекса окончания просмотренного участка,
                // прошлое значение + длина html-вставки + учитываем то, что при эскейпинге размер строки увеличился
                prevEnd = highlightStartIndex + text.length + (texts.fio.length - prevFioLength);

                // при последнем проходе добавляем непросмотренную часть строки
                if (i == arr.length - 1) texts.fio =
                    texts.fio.substr(0, prevEnd) + u.escapeHTML(texts.fio.substr(prevEnd));
            });
        } else {
            texts.fio = u.escapeHTML(texts.fio);
        }

        return {
            item: 'option',
            value: client.login,
            disabled: disabled,
            selected: selected,
            content: [texts.login, ' &ndash; ', texts.fio, '&nbsp;(', client.formattedSumOfMoney, ')']
        };
    },

    /**
     * Возвращает валюту, с которой работает клиент, выбранный в списке "от клиента"
     * @returns {String}
     * @private
     */
    _getWorkingCurrency: function() {
        var index = this.selectFrom.getSelectedIndex();

        return (index > -1 && this._shownSubclients[index] || {}).work_currency || '';
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('init', 'select');
    }

});
