match(function() {
    return this.data.cmd === 'showUploadModerationDocs' || this.data.cmd === 'uploadModerationDocs';
})(

    block('app-main').mode('page-block')('p-upload-subclient-docs'),

    block('b-page')(
        mode('title')(function() {
            return iget2('p-upload-subclient-docs', 'dokumenty-dlya-prohozhdeniya-moderacii', 'Документы для прохождения модерации');
        }),

        mode('content-only')(function() {
            return this.data.FORM.layout == 'off';
        })
    )
);

block('p-upload-subclient-docs')(

    def()(function() {
        return applyNext({
            contentOnly: this.data.FORM.layout == 'off',
            maxFileSizeMB: Math.floor(this.data.MAX_FILE_SIZE / 1000000),
            // если есть пустой массив result значит на страницу попали после сабмита формы
            __successPage: this.data.result && !this.data.result.length
        });
    }),

    js().match(function() {
        return this.__successPage;
    })({
        complete: true
    }),

    js().match(function() {
        return !this.__successPage;
    }).match(function() {
        return this.data.user_data;
    })(function() {
        return {
            contentOnly: this.contentOnly,
            camps: this.data.user_data.camps || {},
            cid: this.data.FORM.currentCid,
            allowedFileTypes: this.data.ALLOWED_DOC_EXTENSIONS,
            //максимальный размер файла в байтах
            MAX_FILE_SIZE: this.data.MAX_FILE_SIZE,
            MAX_FILES_QUANTITY: this.data.MAX_FILE_COUNT,
            maxFileSizeMB: this.maxFileSizeMB
        };
    }),

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: this.contentOnly ? '8-80-8' : '60'
            },
            content: {
                block: 'p-upload-subclient-docs',
                elem: 'content-holder'
            }
        };
    }),

    elem('content-holder').replace()(

        match(function() {
            return !this.__successPage;
        })(function() {
            return [
                {
                    block: 'l-page',
                    elem: 'row',
                    center: [
                        {
                            block: 'b-page-title',
                            mix: this.contentOnly && {
                                block: 'p-upload-subclient-docs',
                                elem: 'low-page-title'
                            },
                            title: iget2('p-upload-subclient-docs', 'zagruzit-dokumenty', 'Загрузить документы')
                        }
                    ]
                },
                this.contentOnly ?
                    {
                        block: 'l-page',
                        elem: 'row',
                        center: [
                            {
                                block: 'b-text',
                                mix: [{
                                    block: 'p-upload-subclient-docs',
                                    elem: 'description'
                                }],
                                content: {
                                    elem: 'p',
                                    content: iget2(
                                        'p-upload-subclient-docs',
                                        'za-odin-raz-mozhno',
                                        'За один раз можно загрузить не более 10 файлов. Размер одного файла не должен превышать {foo} МБ. Не обязательно сразу загружать все файлы &mdash; вы всегда можете добавить оставшиеся документы, вернувшись к уведомлению на странице кампании.',
                                        {
                                            foo: this.maxFileSizeMB
                                        }
                                    )
                                }
                            }
                        ]
                    } :
                    {
                        block: 'l-page',
                        elem: 'row',
                        center: [
                            {
                                block: 'b-text',
                                mix: [{
                                    block: 'p-upload-subclient-docs',
                                    elem: 'description'
                                }],
                                content: {
                                    elem: 'p',
                                    content: iget2(
                                        'p-upload-subclient-docs',
                                        'reklama-nekotoryh-tovarov-i',
                                        'Реклама некоторых товаров и услуг ограничивается действующим законодательством. В частности, это реклама товаров и услуг, которые подлежат обязательной сертификации, регистрации или лицензированию.'
                                    )
                                }
                            },
                            {
                                block: 'b-text',
                                mix: [{
                                    block: 'p-upload-subclient-docs',
                                    elem: 'description'
                                }],
                                content: {
                                    elem: 'p',
                                    content: iget2(
                                        'p-upload-subclient-docs',
                                        'esli-vashi-tovary-ili',
                                        'Если ваши товары или услуги можно рекламировать только при соблюдении особых требований, пожалуйста, ознакомьтесь {rulesLink} и отправьте их нам с помощью формы ниже.',
                                        {
                                            rulesLink: function(text) {
                                                return {
                                                    block: 'b-help-link',
                                                    mods: {
                                                        margin: 'no'
                                                    },
                                                    mix: [{
                                                        block: 'p-upload-subclient-docs',
                                                        elem: 'help-link'
                                                    }],
                                                    url: u.getCommonHelpUrl(
                                                        '/direct/required-docs-rules/required-docs.xml'
                                                    ),
                                                    text: text
                                                };
                                            }(iget2(
                                                'p-upload-subclient-docs',
                                                'esli-vashi-tovary-ili-param-rulesLink',
                                                'с порядком предоставления сопроводительных документов'
                                            )),

                                            context: 'rulesLink - с порядком предоставления сопроводительных документов'
                                        }
                                    )
                                }
                            }
                        ]
                    },
                {
                    block: 'l-page',
                    elem: 'row',
                    center: [{
                        block: 'p-upload-subclient-docs',
                        elem: 'form'
                    }]
                }
            ];
        }),

        match(function() {
            return this.__successPage;
        })(function() {
            return {
                elem: 'docs-uploaded'
            };
        })
    ),

    elem('docs-uploaded').content()(function() {
        var urlParams = {
            ulogin: this.data.FORM.ulogin,
            layout: this.data.FORM.layout
        };

        return {
            block: 'l-page',
            elem: 'row',
            center: {
                block: 'p-upload-subclient-docs',
                elem: 'uploaded-info-wrap',
                content: this.contentOnly ? [
                    {
                        block: 'b-text',
                        mix: [{
                            block: 'p-upload-subclient-docs',
                            elem: 'docs-uploaded-info'
                        }],
                        content: {
                            elem: 'span',
                            content: iget2('p-upload-subclient-docs', 'fayly-uspeshno-zagruzheny', 'Файлы успешно загружены.')
                        }
                    },
                    {
                        block: 'b-text',
                        mix: [{
                            block: 'p-upload-subclient-docs',
                            elem: 'docs-uploaded-info'
                        }],
                        content: {
                            elem: 'span',
                            content: [iget2('p-upload-subclient-docs', 'chto-dalshe', 'Что дальше'), ':']
                        }
                    },
                    {
                        block: 'b-text',
                        mix: [{
                            block: 'p-upload-subclient-docs',
                            elem: 'docs-uploaded-info'
                        }],
                        content: {
                            elem: 'span',
                            content: iget2(
                                'p-upload-subclient-docs',
                                'proverka-mozhet-zanimat-nekotoroe',
                                'Проверка может занимать некоторое время &mdash; пожалуйста, не отправляйте документы повторно.'
                            )
                        }
                    },
                    {
                        block: 'b-text',
                        mix: [{
                            block: 'p-upload-subclient-docs',
                            elem: 'docs-uploaded-info'
                        }],
                        content: {
                            elem: 'span',
                            content: iget2(
                                'p-upload-subclient-docs',
                                'rezultaty-proverki-vy-poluchite',
                                'Результаты проверки вы получите на адрес электронной почты, который вы указали при отправке документов.'
                            )
                        }
                    }
                ] : [
                    {
                        block: 'b-text',
                        mix: [{
                            block: 'p-upload-subclient-docs',
                            elem: 'docs-uploaded-info',
                            elemMods: {
                                'text-size': 'big'
                            }
                        }],
                        content: {
                            elem: 'span',
                            content: iget2('p-upload-subclient-docs', 'spasibo-vashi-dokumenty-uspeshno', 'Спасибо, Ваши документы успешно отправлены.')
                        }
                    },
                    {
                        block: 'link',
                        mix: [{
                            block: 'p-upload-subclient-docs',
                            elem: 'back-link'
                        }],
                        url: u.getUrl('showCamps', urlParams),
                        content: iget2('p-upload-subclient-docs', 'prodolzhit-rabotu', 'Продолжить работу')
                    },
                    {
                        block: 'link',
                        mix: [{
                            block: 'p-upload-subclient-docs',
                            elem: 'back-link'
                        }],
                        url: u.getUrl('showUploadModerationDocs', urlParams),
                        content: iget2('p-upload-subclient-docs', 'otpravit-eshchyo-dokumenty', 'Отправить ещё документы')
                    }
                ]
            }
        };
    }),

    elem('form').content()(function() {
        var camps = this.data.user_data && this.data.user_data.camps,
            errors = this.data.result && this.data.result.join(' ') || '';

        return {
            block: 'b-layout-form',
            mix: {
                block: 'p-upload-subclient-docs',
                elem: 'form'
            },
            attrs: {
                enctype: 'multipart/form-data'
            },
            action: this.data.script,
            method: 'POST',
            mixes: {
                row: [{
                    block: 'p-upload-subclient-docs',
                    elem: 'form-row'
                }],
                label: [{
                    block: 'p-upload-subclient-docs',
                    elem: 'form-label',
                    elemMods: this.contentOnly && {
                        short: 'yes'
                    }
                }],
                control: [{
                    block: 'p-upload-subclient-docs',
                    elem: 'form-control',
                    elemMods: this.contentOnly && {
                        long: 'yes'
                    }
                }]
            },
            hiddenInputs: [
                {
                    name: 'cid',
                    mix: {
                        block: 'p-upload-subclient-docs',
                        elem: 'cid'
                    }
                },
                {
                    name: 'cmd',
                    value: 'uploadModerationDocs'
                },
                {
                    name: 'csrf_token',
                    value: this.data.csrf_token
                },
                {
                    name: 'layout',
                    value: this.data.FORM.layout
                },
                {
                    name: 'ulogin',
                    value: this.data.FORM.ulogin || ''
                }
            ],

            rows: (camps ? [
                this.contentOnly ?
                        '' :
                    {
                        label: iget2('p-upload-subclient-docs', 'klient', 'Клиент') + ':',
                        control: {
                            block: 'p-upload-subclient-docs',
                            elem: 'user-name',
                            content: this.data.user_data.fio + '(' + this.data.user_data.login + ')'
                        }
                    },
                {
                    label: iget2('p-upload-subclient-docs', 'e-mail', 'E-mail') + ':',
                    control: [
                        {
                            block: 'input',
                            mods: {
                                autocomplete: 'off'
                            },
                            mix: [{
                                block: 'p-upload-subclient-docs',
                                elem: 'email'
                            }],
                            content: {
                                elem: 'control',
                                mix: [{
                                    block: 'p-upload-subclient-docs',
                                    elem: 'email-control'
                                }]
                            },
                            value: this.data.FORM.email || '',
                            id: 'email-field',
                            name: 'email'
                        },
                        {
                            block: 'p-upload-subclient-docs',
                            elem: 'email-samples',
                            content: {
                                elem: 'email-sample',
                                content: this.data.user_data.email
                            }
                        }
                    ]
                },
                {
                    label: [
                        {
                            block: 'b-layout-form',
                            elem: 'label',
                            content: iget2('p-upload-subclient-docs', 'nomer-rk', 'Номер РК'),
                            controlId: 'campaign-field'
                        },
                        ': ',
                        {
                            block: 'icon',
                            mods: {
                                'size-13': 'question',
                                theme: 'light'
                            },
                            mix: [{
                                block: 'p-upload-subclient-docs',
                                elem: 'tooltip-switcher',
                                js: {
                                    tooltip: iget2('p-upload-subclient-docs', 'ukazat-mozhno-kampaniyu-kotoraya', 'Указать можно кампанию, которая не находится в архиве.')
                                }
                            }]
                        }
                    ],
                    control: {
                        block: 'input',
                        mix: [{
                            block: 'p-upload-subclient-docs',
                            elem: 'camp-name'
                        }],
                        mods: {
                            suggest: 'yes'
                        },
                        js: {
                            dataprovider: {
                                name: 'i-camp-names-suggest-dataprovider'
                            },
                            campTitle: Object.keys(this.data.user_data.camps).map(function(id) {
                                return id + ' - ' + this.data.user_data.camps[id];
                            }, this),
                            popupMods: {
                                size: 'm'
                            }
                        },
                        content: [
                            {
                                elem: 'control'
                            },
                            {
                                elem: 'message',
                                elemMods: {
                                    type: 'error'
                                }
                            }
                        ],
                        value: this.data.FORM.campaign_name || '',
                        name: 'campaign_name',
                        id: 'campaign-field'
                    }
                },
                {
                    label: iget2('p-upload-subclient-docs', 'fayly', 'Файлы') + ':',
                    control: {
                        block: 'p-upload-subclient-docs',
                        elem: 'attach-list',
                        content: {
                            elem: 'attach',
                            contentOnly: this.contentOnly,
                            maxFileSizeMB: this.maxFileSizeMB
                        }
                    }
                },
                {
                    label: iget2('p-upload-subclient-docs', 'kommentariy', 'Комментарий') + ':',
                    control: [
                        {
                            block: 'input',
                            mods: {
                                type: 'textarea'
                            },
                            mix: [{
                                block: 'p-upload-subclient-docs',
                                elem: 'comment'
                            }],
                            content: {
                                elem: 'control',
                                attrs: this.contentOnly && {
                                    rows: 3
                                },
                                mix: [{
                                    block: 'p-upload-subclient-docs',
                                    elem: 'comment-control'
                                }]
                            },
                            value: this.data.FORM.comment || '',
                            id: 'comment-field',
                            name: 'comment'
                        }
                    ]
                }
            ] : []).concat([{
                elem: 'row',
                content: [
                    {
                        block: 'p-upload-subclient-docs',
                        elem: 'errors',
                        content: [
                            {
                                elem: 'error-wrong-type',
                                elemMods: {
                                    hidden: errors.indexOf('BAD_FILE_TYPE') == -1 ? 'yes' : ''
                                },
                                content: iget2('p-upload-subclient-docs', 'dannyy-format-fayla-ne', 'Данный формат файла не поддерживается.')
                            }
                        ].concat([
                            {
                                code: 'NO_FILES_ATTACHED',
                                message: iget2('p-upload-subclient-docs', 'neobhodimo-prikrepit-hotya-by', 'Необходимо прикрепить хотя бы 1 файл.')
                            },
                            {
                                code: 'INTERNAL_ERROR',
                                message: iget2(
                                    'p-upload-subclient-docs',
                                    'proizoshla-oshibka-pozhaluysta-povtorite',
                                    'Произошла ошибка. Пожалуйста, повторите попытку позже.'
                                )
                            },
                            {
                                code: 'NO_ACTIVE_CAMPAIGNS',
                                message: iget2('p-upload-subclient-docs', 'net-ne-arhivnyh-promoderirovannyh', 'Нет не архивных промодерированных кампаний.')
                            },
                            {
                                code: 'NO_VALID_CAMPAIGN',
                                message: iget2('p-upload-subclient-docs', 'vveden-nepravilnyy-nomer-kampanii', 'Введен неправильный номер кампании.')
                            },
                            {
                                code: 'NO_VALID_EMAIL',
                                message: iget2('p-upload-subclient-docs', 'vveden-nevalidnyy-email', 'Введен невалидный email.')
                            },
                            {
                                code: 'DAY_LIMIT_EXCEEDED',
                                message: iget2(
                                    'p-upload-subclient-docs',
                                    'vy-dostigli-dnevnogo-limita',
                                    'Вы достигли дневного лимита загруженных файлов. Пожалуйста, продолжите работу завтра.'
                                )
                            }
                        ].map(function(error) {
                            return errors.indexOf(error.code) != -1 && {
                                elem: 'server-error',
                                content: error.message
                            };
                        }))
                    }
                ]
            }]),

            submit: camps && {
                block: 'p-upload-subclient-docs',
                elem: 'submit-wrap',
                elemMods: this.contentOnly && {
                    auto: 'yes'
                },
                content: {
                    block: 'button',
                    mods: {
                        disabled: 'yes'
                    },
                    mix: [{
                        block: 'p-upload-subclient-docs',
                        elem: 'submit'
                    }],
                    content: iget2('p-upload-subclient-docs', 'otpravit', 'Отправить')
                }
            }
        };
    })
);
