BEM.DOM.decl('p-upload-subclient-docs', {

    onSetMod: {
        js: function() {

            if (this.params.complete) {
                this._notifyComplete();
            } else {
                //допустимые расширения файлов
                this._allowedFileTypes = new RegExp('(\\.' + this.params.allowedFileTypes.join('|\\.') + ')$', 'i');

                this._bindEvents();

                this.request = BEM.create('i-request_type_ajax', {
                    url: '/registered/main.pl',
                    dataType: 'json',
                    onError: function() {
                        BEM.blocks['b-confirm'].alert(iget2('p-upload-subclient-docs', 'oshibka-zaprosa-poprobuyte-eshchyo', 'Ошибка запроса. Попробуйте ещё раз.'));
                    }
                });

                //блоки элементов с ошибками
                this._errorElems = {
                    size: {
                        block: 'p-upload-subclient-docs',
                        elem: 'error-max-size',
                        content: iget2('p-upload-subclient-docs', 'obyom-fayla-ne-dolzhen', 'Объём файла не должен превышать {foo} МБ.', {
                            foo: this.params.maxFileSizeMB
                        })
                    },
                    noCampaign: {
                        block: 'p-upload-subclient-docs',
                        elem: 'error-wrong-campaign',
                        content: iget2('p-upload-subclient-docs', 'vvedyonnoy-kampanii-ne-sushchestvuet', 'Введённой кампании не существует.')
                    },
                    // элемент шаблонизируется на сервере
                    type: { elem: 'error-wrong-type' }
                };

                this.params.cid && this._campNameInput.val(this._getCampNameWithId(this.params.cid));
            }
        }
    },

    //постфикс в имени поля отправки файла
    _filesPostfix: 0,

    /**
     * Подписывает на события элементов
     *
     * @private
     */
    _bindEvents: function() {
        var attachList = this.elem('attach-list');

        u.graspSelf.call(this, {
            _emailInput: 'input on email',
            _commentInput: 'input on comment',
            _campNameInput: 'input on camp-name',
            _attach: 'attach on attach',
            _submit: 'button on submit'
        });

        this._campNameInput.on('change', this._onCampNameChange, this);

        BEM.DOM.blocks['attach']
            .on(attachList, 'reset', function(e) {
                this._updateAttaches(e.block);
                this._updateSubmitEnabled();
            }, this)
            .on(attachList, 'change', this._onAttachChange, this);

        this._emailInput.on('change paste', function() {
            this._updateSubmitEnabled();
        }, this);

        this.bindTo('tooltip-switcher', 'click', function(e) {
            var switcher = this.findElem($(e.target), 'tooltip-switcher');

            this._getPopup()
                .setContent(this.elemParams(switcher).tooltip)
                .toggle(switcher);
        });

        this._submit.on('click', function() {
            var attaches = this.findBlocksInside(this.elem('attach-list'), 'attach'),
                firstAttach = attaches[0];

            this._submit.setMod('disabled', 'yes');

            //удаляем первый блок аттач если он пустой для того чтобы он не ушел на сервер при сабмите
            !firstAttach.val() && firstAttach.destruct();

            this.elem('form').submit();
        }, this);
    },

    /**
     * Возвращает блок общего попапа
     * @returns {BEM}
     * @private
     */
    _getPopup: function() {
        return this._popup || (this._popup = BEM.blocks['b-shared-popup'].getInstance(
                {},
                { directions: 'right' },
                { content: [{ block: 'p-upload-subclient-docs', elem: 'popup-content' }] }));
    },

    /**
     * Выставляет доступность кнопки сабмит
     *
     * @private
     */
    _updateSubmitEnabled: function() {
        var attaches = this.findBlocksInside(this.elem('attach-list'), 'attach'),
            lastAttach = attaches[attaches.length - 1];

        this._submit.setMod('disabled',
            this._emailInput.val().trim() && lastAttach.val().trim() ? '' : 'yes');
    },

    /**
     * Удаляет блок attach,
     * если нет пустых блоков attach добавляет его,
     * вызывает выставление доступности кнопки сабмит
     *
     * @param {BEM} attachBlock
     * @private
     */
    _updateAttaches: function(attachBlock) {
        attachBlock.destruct();

        var attaches = this.findBlocksInside(this.elem('attach-list'), 'attach');

        //оставляем минимум один пустой блок attach
        !attaches.filter(function(attach) { return !attach.val() }).length && this._addAttach();
    },

    /**
     * Проверяет валидность файлов, если файлы валидные добавляет блок attach, вызывает проверку доступности кнопки
     * отправки формы. Скрывает серверную ошибку
     * Обработчик события change на блоке attach
     *
     * @param {Object} e
     * @private
     */
    _onAttachChange: function(e) {
        var attach = e.block,
            fileRequiredElem = this.elem('error-file-required');

        fileRequiredElem && this.setMod(fileRequiredElem, 'hidden', 'yes');

        if (!this._isFileValid(e)) {
            attach.resetFile();

            return;
        }

        if (e.block.val()) {
            this.setMod(this.findElem(attach.domElem, 'attach'), 'state' , 'file-choosen');
            this._addAttach();
            this._updateSubmitEnabled();
        }
    },

    /**
     * Проверяет размер файла и расширение. При необходимости вызывает показ ошибки
     *
     * @param {Object} e
     * @returns {Boolean} если true - файл валидный
     * @private
     */
    _isFileValid: function(e) {
        if (!e.block.val()) return true;

        var fileName = e.block.val().trim(),
            file = e.block.elem('control')[0].files[0],
            errorElems = this._errorElems,
            errors = [];

        !this._allowedFileTypes.test(fileName) && errors.push(errorElems.type.elem);
        file.size > this.params.MAX_FILE_SIZE && errors.push(errorElems.size.elem);

        this._showErrors(errors);

        return !errors.length;
    },

    /**
     * Показывает элементы с текстом ошибок.
     *
     * @param {Array} currentErrors имена элементов с ошибками
     * @private
     */
    _showErrors: function(currentErrors) {
        currentErrors = currentErrors.join(',');

        Object.keys(this._errorElems).forEach(function(key) {
            var error = this._errorElems[key],
                elemName = error.elem;

            if (!this.elem(elemName).length) {
                BEM.DOM.append(this.elem('errors'), BEMHTML.apply(error));
                this.dropElemCache(elemName);
            }

            this.setMod(this.elem(elemName), 'hidden', currentErrors.indexOf(elemName) != -1 ? '' : 'yes');

        }, this);
    },

    /**
     * Добавляет блок attach в элемент attach-list. Всего можно отправить не более 10 файлов за 1 раз.
     * Добавление блока происходит после того как пользователь выбрал файл.
     *
     * @private
     */
    _addAttach: function() {
        if (this.findBlocksInside(this.elem('attach-list'), 'attach').length >= this.params.MAX_FILES_QUANTITY) return;

        BEM.DOM.prepend(this.elem('attach-list'), BEMHTML.apply({
            block: 'p-upload-subclient-docs',
            elem: 'attach',
            contentOnly: this.params.contentOnly,
            maxFileSizeMB: this.params.maxFileSizeMB,
            filesPostfix: ++this._filesPostfix
        }));
    },

    /**
     * Проверяет существование кампании по введенному значению в поле "Кампания".
     * В случае ошибки показывает ее, вызывает подгрузку доменов и телефонов кампании
     * Обновляет поле cid
     *
     * @private
     */
    _onCampNameChange: function(e, data) {
        var campName = this._campNameInput.val().trim().toLowerCase(),
            cid;

        campName && Object.keys(this.params.camps).some(function(campId) {
            if (~this._getCampNameWithId(campId).toLowerCase().indexOf(campName)) {
                cid = campId;

                return true
            }

            return false;
        }, this);

        this._showErrors(campName && !cid ? [this._errorElems.noCampaign.elem] : []);

        this.elem('cid').val(cid || '');
    },

    /**
     * Формирует строку с id кампании и её названием, разделённые дефисом
     * @param {Number} cid
     * @return {String}
     * @private
     */
    _getCampNameWithId: function(cid) {
        return cid + ' - ' + this.params.camps[cid];
    },

    /**
     * Добавляет выбранное из примеров email значения в поле "E-mail"
     *
     * @param {Object} e
     * @private
     */
    _updateEmailValue: function(e) {
        var sampleText = $(e.target).text().trim(),
            value = this._emailInput.val().trim();

        value = value ? value.split(', ') : [];

        if (value.indexOf(sampleText) != -1) {
            value = value.filter(function(item) { return item != sampleText; }, []);
        } else {
            value.push(sampleText);
        }

        this._emailInput.val(value.join(', '));
    },

    /**
     * Оповещает открывающую страницу о завершении сценария
     * @event upload-subclient-docs-complete
     * @private
     */
    _notifyComplete: function() {
        BEM.blocks['i-event-bus']
            .getEventBus(window.name)
            .trigger('upload-subclient-docs-complete');
    }

}, {

    live: function() {
        this.liveBindTo('email-sample', 'click', function(e) {
            this._updateEmailValue(e);
        });

        return false;
    }

});
