match(function() {
    return this.data.cmd === 'userSettings';
})(

    block('app-main').mode('page-block')('p-user-settings'),

    block('b-page').mode('title')(

        match(function() {
            return true;
        })(function() {
            return iget2('p-user-settings', 'nastroyki-polzovatelya', 'Настройки пользователя');
        }),

        match(function() {
            return this.data.UID != this.data.uid && hasLoginRights('is_any_client');
        })(function() {
            return iget2('p-user-settings', 'nastroyki-predstavitelya', 'Настройки представителя');
        })
    )

);

block('p-user-settings')(

    def()(function() {
        var data = this.data;

        return applyNext({
            phone: data.verified_phone ? data.verified_phone.phone : data.phone,
            verifiedPhoneId: data.verified_phone ? data.verified_phone.phone_id : undefined,
            enableVerifiedPhonesCollecting: Boolean(data.enable_collecting_verified_phones) &&
                Boolean(data.collecting_verified_phones_mutable),
            isStandaloneClient: this.data.user_role == 'client' && !this.data.client.client_have_agency,
            //страницу просматривает представитель
            isAgent: this.data.UID != this.data.uid && hasLoginRights('is_any_client'),
        });
    }),

    addJs()(function() {
        var data = this.data;

        return {
            ulogin: data.user_login,
            tld: this['i-global'].tld,
            isPolicyAccepted: data.client_country === '225',  // Россия
            phone: this.phone,
            verifiedPhoneId: this.verifiedPhoneId,
            enableVerifiedPhonesCollecting: this.enableVerifiedPhonesCollecting,
        };
    }),

    content()(function() {
        var isTelegramEnabled = u.consts('isTelegramEnabled');
        var readonlyRepsEnabled = u._.contains(this.data.features_enabled_for_client_all, 'READONLY_REPS');

        var isHomepageSettingsEnabled = u._.contains(this.data.features_enabled_for_client_all, 'OVERVIEW_ENABLED');
        var isCampaignsListSelectedAsHomepage = u._.contains(this.data.features_enabled_for_client_all, 'HOMEPAGE_USE_GRID');

        var isRepTypeSelectEnabled = this.data.rep_type && this.data.rep_type !== 'chief' && readonlyRepsEnabled;
        var client = this.data.client;
        var clientTin = client.tin;
        var clientTinType = client.tin_type || '';
        var modelData = [
            'video_blacklist_size_limit',
            'email',
            'recommendations_email',
            'fio',
            'phone',
            'news',
            'tags_allowed',
            'warn',
            'accnews',
            'send_all_camp_letters',
            'send_all_camp_sms',
            'use_camp_description',
            'can_use_day_budget',
            'hide_market_rating',
            'auto_video',
            'email_lang',
            'metrika_counters',
            'videohints_enabled'
        ].reduce(function(res, key) {
            res[key] = this.data[key];

            return res;
        }.bind(this), {});
        var isEditTinEnabledInUserSettings = u.consts('isEditTinEnabledInUserSettings');
        var isEnableVideoHintsSettings = u.consts('isEnableVideoHintsSettings');
        var isCampaignEditPageVideoHints = u.consts('isCampaignEditPageVideoHints');
        var tinTypeItems = [
            {
                text: iget2('p-user-settings', 'none-tin-type', 'Не выбрано'),
                val: ''
            },
            {
                text: iget2('p-user-settings', 'physical-tin-type', 'Физическое лицо'),
                val: 'physical'
            },
            {
                text: iget2('p-user-settings', 'legal-tin-type', 'Юридическое лицо'),
                val: 'legal'
            }
        ];
        var selectedTinType = tinTypeItems.find(function(item) {
            return item.val === clientTinType
        });

        if (isEditTinEnabledInUserSettings) {
            modelData.tin = clientTin;
            modelData.tin_type = clientTinType;
        }

        return {
            block: 'l-page',
            mods: {
                layout: '16-60-16'
            },
            content: [
                {
                    elem: 'row',
                    left: true,
                    right: true,
                    center: {
                        block: 'b-page-title',
                        title: this.isAgent ? iget2('p-user-settings', 'nastroyki-predstavitelya', 'Настройки представителя') : iget2('p-user-settings', 'nastroyki-polzovatelya', 'Настройки пользователя')
                    }
                },
                {
                    elem: 'row',
                    left: true,
                    right: true,
                    center: {
                        block: 'b-layout-form',
                        mix: [{
                            block: 'b-user-settings',
                            js: {
                                showAllEmailsUrl: u.getUrl('showUserEmails', withUidPar({
                                    cid: this.data.cid || '',
                                    format: 'json'
                                })),
                                modelName: 'm-user-settings',
                                modelData: modelData,
                            }
                        }, {
                            block: 'i-form',
                            mods: {
                                submit: 'bem-event'
                            }
                        }],
                        mods: {
                            layout: '27-71'
                        },

                        mixes: {
                            row: [{
                                block: 'b-user-settings',
                                elem: 'row'
                            }],
                            label: [{
                                block: 'b-user-settings',
                                elem: 'label'
                            }],
                            control: [{
                                block: 'b-user-settings',
                                elem: 'control'
                            }],
                            submit: [{
                                block: 'b-user-settings',
                                elem: 'submit'
                            }]
                        },

                        header: {
                            block: 'b-user-settings',
                            elem: 'error',
                            elemMods: {
                                id: 'main'
                            }
                        },
                        submit: {
                            block: 'button',
                            mods: { size: 'm', theme: 'action' },
                            type: 'submit',
                            content: iget2('p-user-settings', 'sohranit', 'Сохранить')
                        },
                        action: this.data.script,
                        method: 'GET',

                        attrs: {
                            name: 'save'
                        },

                        hiddenInputs: [
                            {
                                name: 'ulogin',
                                value: this.data.FORM.ulogin
                            },
                            {
                                name: 'cmd',
                                value: 'saveSettings'
                            },
                            this.enableVerifiedPhonesCollecting && {
                                name: 'verified_phone_id',
                                mix: {
                                    block: 'b-user-settings',
                                    elem: 'verified-phone-id'
                                },
                                value: this.verifiedPhoneId
                            },
                            this.data.FORM.rcmd && {
                                name: 'rcmd',
                                value: this.data.FORM.rcmd
                            }
                        ].filter(function(item) {
                            return !!item;
                        }),

                        rows: [
                            {
                                label: this.isStandaloneClient ?
                                    iget2('p-user-settings', 'adres-el-pochty-dlya', 'Адрес эл. почты для автоматических уведомлений') : iget2('p-user-settings', 'kontaktnyy-adres-el-pochty', 'Контактный адрес эл. почты'),
                                control: (this.data.validEmails && [{
                                    block: 'select',
                                    mods: { size: 'm' },
                                    name: 'email',
                                    mix: [
                                        {
                                            block: 'b-user-settings',
                                            elem: 'email'
                                        },
                                        {
                                            block: 'b-user-settings',
                                            elem: 'model-field',
                                            js: {
                                                type: 'select',
                                                name: 'email'
                                            }
                                        }
                                    ],
                                    content: [
                                        {
                                            block: 'button',
                                            mods: { size: 'm' },
                                            content: this.data.email
                                        },
                                        {
                                            elem: 'control',
                                            content: this.data.validEmails.map(function(email) {
                                                var option = {
                                                    elem: 'option',
                                                    attrs: {
                                                        value: email.email
                                                    },
                                                    content: email.email
                                                };
                                                if (email.select) {
                                                    option.attrs.selected = 'selected';
                                                }
                                                return option;
                                            })
                                        }
                                    ]
                                },
                                    !hasLoginRights('is_developer') && {
                                        block: 'dropdown',
                                        mix: [{
                                            block: 'b-user-settings',
                                            elem: 'email-add-new-dropdown'
                                        }],
                                        content: [
                                            {
                                                block: 'button',
                                                mix: [
                                                    {
                                                        block: 'b-user-settings',
                                                        elem: 'email-add-new'
                                                    },
                                                    {
                                                        block: 'dropdown',
                                                        elem: 'switcher'
                                                    }
                                                ],
                                                mods: {
                                                    size: 'm',
                                                    pseudo: 'yes'
                                                },
                                                content: iget2('p-user-settings', 'dobavit-novyy', 'добавить новый')
                                            },
                                            {
                                                elem: 'popup',
                                                js: {
                                                    directions: 'bottom'
                                                },
                                                elemMods: { disposition: 'dropdown' },
                                                content: {
                                                    block: 'b-user-settings-add-email',
                                                    mix: [{
                                                        block: 'b-user-settings',
                                                        elem: 'email-add-new-popup'
                                                    }],
                                                    content: [
                                                        {
                                                            elem: 'header',
                                                            content: iget2('p-user-settings', 'dobavlenie-novogo-pochtovogo-adresa', 'Добавление нового почтового адреса')
                                                        },
                                                        {
                                                            elem: 'center',
                                                            content: [
                                                                {
                                                                    block: 'b-user-settings',
                                                                    elem: 'error',
                                                                    elemMods: {
                                                                        id: 'add-new-email'
                                                                    }
                                                                },
                                                                {
                                                                    block: 'b-layout-form',
                                                                    mix: [
                                                                        {
                                                                            block: 'b-user-settings-add-email',
                                                                            elem: 'form'
                                                                        },
                                                                        {
                                                                            block: 'i-form'
                                                                        }
                                                                    ],
                                                                    mods: {
                                                                        inner: 'yes'
                                                                    },

                                                                    method: 'POST',
                                                                    action: this.data.SCRIPT_CLEAR,

                                                                    header: {
                                                                        block: 'b-user-settings-add-email',
                                                                        elem: 'error'
                                                                    },

                                                                    hiddenInputs: [
                                                                        {
                                                                            name: 'cmd',
                                                                            value: 'saveEmail'
                                                                        },
                                                                        {
                                                                            name: 'format',
                                                                            value: 'json'
                                                                        },
                                                                        this.data.uid_par && {
                                                                            name: this.data.uid_par.key,
                                                                            value: this.data.uid_par.value
                                                                        },
                                                                        this.data.cid && {
                                                                            name: 'cid',
                                                                            value: this.data.cid || ''
                                                                        }
                                                                    ].filter(function(item) {
                                                                        return !!item;
                                                                    }),

                                                                    rows: [
                                                                        {
                                                                            mixes: {
                                                                                label: [{
                                                                                    block: 'b-user-settings-add-email',
                                                                                    elem: 'label'
                                                                                }],
                                                                                control: [{
                                                                                    block: 'b-user-settings-add-email',
                                                                                    elem: 'new-email'
                                                                                }]
                                                                            },
                                                                            label: {
                                                                                content: iget2('p-user-settings', 'el-nbsp-pochta', 'Эл.&nbsp;почта'),
                                                                                for: 'newemail'
                                                                            },
                                                                            control: {
                                                                                block: 'input',
                                                                                content: {
                                                                                    elem: 'control'
                                                                                },
                                                                                name: 'newemail'
                                                                            }
                                                                        }
                                                                    ]
                                                                }
                                                            ]
                                                        },
                                                        {
                                                            block: 'b-user-settings-add-email',
                                                            elem: 'controls',
                                                            content: [
                                                                {
                                                                    block: 'button',
                                                                    mix: [{
                                                                        block: 'b-user-settings-add-email',
                                                                        elem: 'accept'
                                                                    }],
                                                                    content: iget2('p-user-settings', 'ok', 'ОК')
                                                                },
                                                                {
                                                                    block: 'button',
                                                                    mix: [{
                                                                        block: 'b-user-settings-add-email',
                                                                        elem: 'decline'
                                                                    }],
                                                                    content: iget2('p-user-settings', 'otmena', 'Отмена')
                                                                }
                                                            ]
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                elem: 'hidden-input'
                                            }
                                        ]
                                    },

                                    (this.data.count_emails > 1 && {
                                        block: 'dropdown',
                                        mix: [{
                                            block: 'b-user-settings',
                                            elem: 'email-show-all-dropdown'
                                        }],
                                        content: [
                                            {
                                                block: 'button',
                                                mix: [
                                                    {
                                                        block: 'b-user-settings',
                                                        elem: 'email-show-all'
                                                    },
                                                    {
                                                        block: 'dropdown',
                                                        elem: 'switcher'
                                                    }
                                                ],
                                                mods: {
                                                    size: 'm',
                                                    pseudo: 'yes'
                                                },
                                                content: [iget2('p-user-settings', 'pokazat-vse', 'показать все'), '&hellip;']
                                            },
                                            {
                                                elem: 'popup',
                                                elemMods: {
                                                    'has-close': 'yes',
                                                    adaptive: 'yes'
                                                },
                                                js: {
                                                    to: 'bottom'
                                                },
                                                mix: [{
                                                    block: 'b-user-settings',
                                                    elem: 'email-show-all-popup'
                                                }],
                                                content: {
                                                    block: 'b-user-settings',
                                                    elem: 'spin',
                                                    content: {
                                                        block: 'spin',
                                                        mods: {
                                                            progress: 'yes',
                                                            theme: 'gray-48'
                                                        }
                                                    }
                                                }
                                            }
                                        ]
                                    })]) || {
                                        block: 'input',
                                        mods: { size: 'm' },
                                        mix: [
                                            {
                                                block: 'b-user-settings',
                                                elem: 'model-field',
                                                js: {
                                                    type: 'input',
                                                    name: 'email'
                                                }
                                            }
                                        ],
                                        content: {
                                            elem: 'control',
                                            attrs: {
                                                id: 'email'
                                            }
                                        },
                                        name: 'email',
                                        value: this.data.email
                                    }
                            },
                            isTelegramEnabled && {
                                label: iget2('p-user-settings', 'telegram', 'Аккаунт Telegram для уведомлений'),
                                control: {
                                    block: 'p-user-settings',
                                    elem: 'telegram',
                                    js: true,
                                    content: {
                                        block: 'p-user-settings',
                                        elem: 'telegram-spin-container',
                                        content: {
                                            block: 'spin2',
                                            mods: { size: 'xxs', progress: 'yes' }
                                        }
                                    },
                                }
                            },
                            this.isStandaloneClient && {
                                label: iget2('p-user-settings', 'adres-el-pochty-dlya-106', 'Адрес эл. почты для новостей и рекомендаций'),
                                control: {
                                    block: 'input',
                                    mods: { size: 'm' },
                                    mix: [
                                        {
                                            block: 'b-user-settings',
                                            elem: 'model-field',
                                            js: {
                                                name: 'recommendations_email',
                                                type: 'input'
                                            }
                                        }
                                    ],
                                    content: {
                                        elem: 'control'
                                    },
                                    name: 'recommendations_email',
                                    value: this.data.recommendations_email
                                }
                            },
                            {
                                label: this.data.UID != this.data.uid ? iget2('p-user-settings', 'nazvanie-predstavitelya', 'Название представителя') : iget2('p-user-settings', 'vashi-fio', 'Ваши ФИО'),
                                control: {
                                    block: 'input',
                                    mods: { size: 'm' },
                                    content: {
                                        elem: 'control'
                                    },
                                    name: 'fio',
                                    value: this.data.fio
                                }
                            },
                            {
                                label: iget2('p-user-settings', 'telefon', 'Телефон'),
                                control: {
                                    block: 'p-user-settings',
                                    elem: 'phone',
                                    content: {
                                        block: 'input',
                                        mods: {
                                            size: 'm',
                                            disabled: this.enableVerifiedPhonesCollecting ? 'yes' : undefined
                                        },
                                        mix: [
                                            {
                                                block: 'b-user-settings',
                                                elem: 'model-field',
                                                js: {
                                                    name: 'phone',
                                                    type: 'input'
                                                }
                                            }
                                        ],
                                        js: true,
                                        content: {
                                            elem: 'control'
                                        },
                                        name: 'phone',
                                        value: this.phone
                                    }
                                }
                            },
                            isEditTinEnabledInUserSettings && {
                                label: [
                                    iget2('p-user-settings', 'tin-type', 'Тип лица'),
                                    {
                                        block: 'b-icon-hint',
                                        icon: { 'size-13': 'question', theme: 'light' },
                                        mix: [
                                            { block: 'p-user-settings', elem: 'hint-icon' }
                                        ],
                                        content: {
                                            block: 'p-user-settings',
                                            elem: 'hint-content',
                                            content: iget2('p-user-settings', 'tin-type-hint', 'Индивидуальные предприниматели и самозанятые являются физическими лицами.')
                                        }
                                    }
                                ],
                                control: [
                                    {
                                        block: 'p-user-settings',
                                        elem: 'tin-type',
                                        content: {
                                            block: 'select',
                                            mods: { size: 'm' },
                                            mix: [
                                                {
                                                    block: 'b-user-settings',
                                                    elem: 'model-field',
                                                    js: {
                                                        type: 'select',
                                                        name: 'tin_type'
                                                    }
                                                }
                                            ],
                                            name: 'tin_type',
                                            value: clientTinType,
                                            content: [
                                                { block: 'button', mods: { size: 'm' }, content: selectedTinType.text },
                                                {
                                                    elem: 'control',
                                                    content: tinTypeItems.map(function(item) {
                                                        var result = {
                                                            elem: 'option',
                                                            attrs: {
                                                                value: item.val
                                                            },
                                                            content: item.text
                                                        };

                                                        if (clientTinType === item.val) {
                                                            result.attrs.selected = 'selected';
                                                        }

                                                        return result;
                                                    })
                                                }
                                            ]
                                        }
                                    }
                                ]
                            },
                            isEditTinEnabledInUserSettings && {
                                label: [
                                    iget2('p-user-settings', 'tin', 'ИНН'),
                                    {
                                        block: 'b-icon-hint',
                                        icon: { 'size-13': 'question', theme: 'light' },
                                        mix: [
                                            { block: 'p-user-settings', elem: 'hint-icon' }
                                        ],
                                        content: {
                                            block: 'p-user-settings',
                                            elem: 'hint-content',
                                            content: iget2(
                                                'p-user-settings',
                                                'tin-hint', 'Узнать свой ИНН можно на сайте {link}',
                                                {
                                                    link: {
                                                        block: 'link',
                                                        mods: {
                                                            theme: 'white'
                                                        },
                                                        url: 'https://service.nalog.ru/inn.do',
                                                        target: '_blank',
                                                        text: 'nalog.ru'
                                                    }
                                                }
                                            )
                                        }
                                    }
                                ],
                                control: {
                                    block: 'p-user-settings',
                                    elem: 'tin',
                                    content: {
                                        block: 'input',
                                        mods: {
                                            size: 'm'
                                        },
                                        mix: [
                                            {
                                                block: 'b-user-settings',
                                                elem: 'model-field',
                                                js: {
                                                    name: 'tin',
                                                    type: 'input'
                                                }
                                            }
                                        ],
                                        js: true,
                                        content: {
                                            elem: 'control'
                                        },
                                        name: 'tin',
                                        value: clientTin
                                    }
                                }
                            },
                            !hasLoginRights('superreader') && {
                                label: iget2('p-user-settings', 'schyotchik-metriki-dlya-novyh', 'Счётчик Метрики для новых кампаний'),
                                control: {
                                    block: 'b-metrika-counters-popup-adapter',
                                    js: {
                                        needCheckCountersOwner: true
                                    },
                                    buttonSize: 'm',
                                    metrikaCounters: this.data['metrika_counters'],
                                    dataModel: 'm-user-settings',
                                    mixHintElem: {
                                        block: 'p-user-settings',
                                        elem: 'hint'
                                    },
                                    isExperimentsOn: false
                                }
                            },
                            !this.isStandaloneClient && {
                                label: iget2('p-user-settings', 'poluchat-rekomendacii', 'Получать рекомендации'),
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.sendNews == 'CHECKED' ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        value: 'on',
                                        name: 'news'
                                    }
                                }
                            },
                            {
                                label: iget2('p-user-settings', 'pokazyvat-metki', 'Показывать метки'),
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.tags_allowed == 'CHECKED' ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        value: 'on',
                                        name: 'tags_allowed'
                                    }
                                }
                            },
                            {
                                label: {
                                    elem: 'label',
                                    content: iget2('p-user-settings', 'otklyuchit-uvedomleniya-sovety-i', 'Отключить уведомления (советы и новости) в интерфейсе'),
                                    attrs: {
                                        title: iget2(
                                            'p-user-settings',
                                            'esli-ispolzovat-etu-nastroyku',
                                            'Если использовать эту настройку, блок с уведомлениями в интерфейсе не будет разворачиваться автоматически.'
                                        )
                                    },
                                    controlId: 'optionsFoldInfoblock'
                                },
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.opts_fold_infoblock == 'CHECKED' ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        id: 'optionsFoldInfoblock',
                                        value: 'on',
                                        name: 'opts_fold_infoblock'
                                    }
                                }
                            },
                            isEnableVideoHintsSettings && isCampaignEditPageVideoHints && {
                                label: {
                                    elem: 'label',
                                    content: iget2('p-user-settings', 'toggle-video-hints', 'Показывать видеоподсказки'),
                                    controlId: 'videohints_enabled'
                                },
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.videohints_enabled ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        value: '1',
                                        name: 'videohints_enabled'
                                    }
                                }
                            },
                            isHomepageSettingsEnabled && {
                                label: {
                                    elem: 'label',
                                    content: iget2('p-user-settings', 'ispolzovat-kak-glavnuu', 'Использовать в качестве главной страницы'),
                                },
                                control: {
                                    block: 'radio-button',
                                    name: 'homepage',
                                    mix: [
                                        {
                                            block: 'b-user-settings',
                                            elem: 'homepage'
                                        }
                                    ],
                                    value: isCampaignsListSelectedAsHomepage ? 'campaigns' : 'overview',
                                    content: [
                                        {
                                            elem: 'radio',
                                            controlAttrs: { value: 'overview' },
                                            content: iget2('p-user-settings', 'obzor', 'Страница Обзор')
                                        },
                                        {
                                            elem: 'radio',
                                            controlAttrs: { value: 'campaigns' },
                                            content: iget2('p-user-settings', 'spisok-kampaniy', 'Список кампаний')
                                        }
                                    ]
                                }
                            },
                            {
                                label: {
                                    elem: 'label',
                                    tag: 'label',
                                    attrs: {
                                        for: 'warn_id'
                                    },
                                    content: iget2('p-user-settings', 'poluchat-preduprezhdeniya-o-smene2', 'Получать предупреждения об изменении объёма трафика')
                                },
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.sendWarn == 'CHECKED' ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        id: 'warn_id',
                                        value: 'on',
                                        name: 'warn'
                                    }
                                }
                            },
                            (this.data.login_rights.client_chief_uid !== this.data.uid && {
                                label: iget2('p-user-settings', 'poluchat-uvedomleniya-po-vsem', 'Получать уведомления по всем кампаниям'),
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.send_all_camp_letters === 'Yes' ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        value: '1',
                                        name: 'send_all_camp_letters'
                                    }
                                }
                            }),
                            (this.data.login_rights.client_chief_uid !== this.data.uid && {
                                label: {
                                    elem: 'label',
                                    tag: 'label',
                                    cls: this.data.sms_phone ? '' : 'disabled',
                                    content: iget2('p-user-settings', 'poluchat-sms-po-vsem', 'Получать SMS по всем кампаниям'),
                                    attrs: {
                                        id: 'send_all_camp_sms_id'
                                    }
                                },
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.sms_phone && this.data.send_all_camp_sms === 'Yes' ?
                                            'yes' :
                                            '',
                                        disabled: !this.data.sms_phone ? 'yes' : undefined
                                    },
                                    checkboxAttrs: {
                                        id: 'send_all_camp_sms_id',
                                        value: '1',
                                        name: 'send_all_camp_sms'
                                    }
                                }
                            }),
                            {
                                label: iget2('p-user-settings', 'pokazyvat-primechaniya-k-kampaniyam', 'Показывать примечания к кампаниям'),
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.use_camp_description === 'Yes' ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        value: '1',
                                        name: 'use_camp_description'
                                    }
                                }
                            },
                            {
                                label: iget2('p-user-settings', 'yazyk-uvedomleniy', 'Язык уведомлений'),
                                control: {
                                    block: 'select',
                                    mods: { size: 'm' },
                                    name: 'email_lang',
                                    mix: [{
                                        block: 'b-user-settings',
                                        elem: 'email-lang'
                                    }],
                                    content: [
                                        {
                                            block: 'button',
                                            mods: { size: 'm' },
                                            content: this.data.email_lang
                                        },
                                        {
                                            elem: 'control',
                                            //#DIRECT-18603
                                            content: (this.data.yandex_domain == 'yandex.com.tr' ?
                                                ['en', 'tr'] :
                                                ['en', 'ru', 'ua']).map(function(lang) {
                                                    var option = {
                                                        elem: 'option',
                                                        attrs: {
                                                            value: lang
                                                        },
                                                        content: lang
                                                    };
                                                    if (lang === this.data.email_lang) {
                                                        option.attrs.selected = 'selected';
                                                    }
                                                    return option;
                                                }.bind(this))
                                        }
                                    ]
                                }
                            },
                            this.data.yandex_domain != 'yandex.com.tr' && {
                                label: [
                                    iget2('p-user-settings', 'dopolnyat-obyavleniya-dannymi-iz', 'Дополнять объявления данными из внешних источников'),
                                    {
                                        block: 'b-help-link',
                                        mods: {
                                            type: 'modal'
                                        },
                                        url: u.getHelpUrl('enrich-ads-with-third-party-data')
                                    }
                                ],
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.show_market_rating === 1 ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        value: '1',
                                        name: 'show_market_rating'
                                    }
                                }
                            },
                            {
                                label: [
                                    iget2('p-user-settings', 'avtomaticheski-ispravlyat-oshibki-i', 'Автоматически исправлять ошибки и опечатки'),
                                    {
                                        block: 'b-help-link',
                                        mix: {
                                            block: 'b-user-settings',
                                            elem: 'help-icon'
                                        },
                                        mods: {
                                            type: 'modal'
                                        },
                                        url: u.getHelpUrl('fixed-spelling-errors')
                                    }
                                ],
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.text_autocorrection ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        value: '1',
                                        name: 'text_autocorrection'
                                    }
                                },
                                // не очень красиво правим перенос ссылки на хелп на следующую строку
                                mixes: {
                                    label: {
                                        block: 'p-user-settings',
                                        elem: 'fix-line-break'
                                    }
                                }
                            },
                            {
                                label: [
                                    iget2('p-user-settings', 'videodopolneniya', 'Видеодополнения'),
                                    {
                                        block: 'b-help-link',
                                        mix: {
                                            block: 'b-user-settings',
                                            elem: 'help-icon'
                                        },
                                        mods: {
                                            type: 'modal'
                                        },
                                        url: u.getHelpUrl('video-extension')
                                    }
                                ],
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.auto_video ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        value: '1',
                                        name: 'auto_video'
                                    },
                                    text: iget2(
                                        'p-user-settings',
                                        'avtomaticheski-dobavlyat-k-novym',
                                        'автоматически добавлять к новым текстово-графическим объявлениям'
                                    )
                                }
                            },
                            u.consts('isSimplifiedStrategyViewEnabled') && {
                                label: [
                                    iget2('p-user-settings', 'pro-strategy-view', 'Показывать настройки опытных пользователей'),
                                ],
                                control: {
                                    block: 'checkbox',
                                    mods: {
                                        view: 'default',
                                        theme: 'normal',
                                        tone: 'market',
                                        checked: this.data.is_pro_strategy_view_enabled ? 'yes' : ''
                                    },
                                    checkboxAttrs: {
                                        value: '1',
                                        name: 'is_pro_strategy_view_enabled'
                                    }
                                }
                            },
                            isRepTypeSelectEnabled && {
                                label: iget2('p-user-settings', 'access', 'Права доступа'),
                                control: {
                                    block: 'select',
                                    mods: { size: 'm' },
                                    mix: {
                                        block: 'b-user-settings',
                                        elem: 'access-select'
                                    },
                                    name: 'rep_type',
                                    content: [
                                        {
                                            block: 'button',
                                            mods: { size: 'm' }
                                        },
                                        {
                                            elem: 'control',
                                            content: [
                                                {
                                                    title: iget2('p-user-settings', 'access-main', 'Полный доступ'),
                                                    value: 'main'
                                                },
                                                {
                                                    title: iget2('p-user-settings', 'access-readonly', 'Только чтение'),
                                                    value: 'readonly'
                                                }
                                            ].map(function(item) {
                                                return {
                                                    elem: 'option',
                                                    attrs: u._.extend({ value: item.value },
                                                        item.value == this.data.rep_type ? { selected: 'selected' } : {}),
                                                    content: item.title
                                                };
                                            }, this)
                                        }
                                    ]
                                }
                            },
                        ].filter(function(item) {
                            return !!item;
                        })
                    }
                }
            ]
        };
    })
);
