BEM.DOM.decl({ block: 'p-user-settings' }, {
    onSetMod: {
        js: function() {
            if (!window.dna) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            var isTelegramEnabled = u.consts('isTelegramEnabled');

            if (isTelegramEnabled) {
                this._renderTelegramEditorWrapperFromDna(window.dna);
            }

            if (!this.params.enableVerifiedPhonesCollecting) {
                return;
            }

            u.graspSelf.call(this, {
                settings: 'b-user-settings inside'
            });

            var ulogin = this.params.ulogin,
                phone = this.params.phone,
                verifiedPhoneId = this.params.verifiedPhoneId,
                isPolicyAccepted = this.params.isPolicyAccepted,
                tld = this.params.tld;

            this._renderPhoneConfirmEditorWrapperFromDna(
                window.dna,
                ulogin,
                phone,
                verifiedPhoneId,
                isPolicyAccepted,
                tld
            );
        }
    },

    _renderPhoneConfirmEditorWrapperFromDna: function(dna, login, phone, verifiedPhoneId, isPolicyAccepted, tld) {
        var dnaComp = dna.reactCreateElement(
            dna.components.PhoneConfirmEditorWrapper,
            {
                login: login,
                tld: tld,
                buttonView: 'pseudo',
                codeTimerLimit: 90,
                phoneInputName: 'phone',
                isPolicyAccepted: isPolicyAccepted,
                phone: phone || '',
                phoneId: verifiedPhoneId,
                clientFeatures: u.consts('clientFeaturesAll'),
                operatorFeatures: u.consts('operatorFeaturesAll')
            },
            null,
            {
                disableBaobab: true
            }
        );

        if (verifiedPhoneId) {
            this.settings.setVerifiedPhoneRequired(true);
        }

        return new Promise(function(resolve) {
            dna.reactDOMRender(
                dnaComp,
                this.elem('phone').get(0),
                function() {
                    resolve(this);
                }
            );
        }.bind(this)).then(function(res) {
            if (res.store) {
                this.settings.setStore(res.store);
            }
        }.bind(this));
    },

    _renderTelegramEditorWrapperFromDna: function(dna) {
        var dnaComp = dna.reactCreateElement(dna.components.TelegramAccountBindingEditorWrapper, {}, null);

        this.setMod(this.elem('telegram-spin-container'), 'visible', 'no');

        dna.reactDOMRender(
            dnaComp,
            this.elem('telegram').get(0)
        );
    }
});
