match(function() {
    return this.data.cmd === 'videoEditorPreview';
})(
block('app-main')(
    mode('page-block')('p-video-constructor-preview'),
    mode('is-footer-enabled')(false),
    mode('is-header-enabled')(false)
),
block('b-page')(
    elem('static-js').replace()(function() {
        return [
            this.addUtilityScripts(),
            {
                elem: 'js',
                attrs: { crossorigin: 'anonymous' },
                url: this.expandStaticFileNameForDna('static/js/videoCreatorPreview.ru.js')
            },
            {
                elem: 'js',
                content: '(function(){var root=document.getElementById("app-wrapper");' +
                'if(root){' +
                'var elem = videoCreatorPreview.reactCreateElement(videoCreatorPreview.components.VideoCreatorPreview);' + //ignore stringify
                'window.Ya&&Ya.Rum&&Ya.Rum.sendTimeMark&&Ya.Rum.sendTimeMark(\'3070\');' +
                'videoCreatorPreview.reactDOMRender(elem, root);' +
                'window.Ya&&Ya.Rum&&Ya.Rum.sendTimeMark&&Ya.Rum.sendTimeMark(\'3036\');' +
                '}})()'
            }
        ];
    }),

    mode('head')(function() {
        return [
            {
                elem: 'js',
                content: applyCtx({
                    block: 'i-rum-timing'
                })
            },
            {
                elem: 'js',
                content: applyCtx({
                    block: 'i-rum-error-counter'
                })
            },
            {
                elem: 'css',
                attrs: { crossorigin: 'anonymous' },
                url: this.expandStaticFileNameForDna('static/css/videoCreatorPreview.ru.css')
            },
            {
                elem: 'css',
                content: 'body { padding:0; margin:0; }'
            },
            this.addFavicons()
        ];
    }),

    elem('body').replace()(function() {
        return [
            { elem: 'content' },
            { elem: 'static-js' }
        ];
    })
));

block('p-video-constructor-preview')(
    content()(function() {
        var data = this.data,
            queryParams,
            videoScale;

        queryParams = u.parseUrl(data.current_url).query;
        videoScale = queryParams.scale ? queryParams.scale : 1;

        return [
            {
                elem: 'app-wrapper',
                attrs: {
                    id: 'app-wrapper',
                    style: 'zoom: ' + videoScale,
                },
                content: ''
            }
        ];
    })
);
