match(function() {
    return this.data.cmd === 'showContactInfo';
})(

    block('app-main').mode('page-block')('p-view-vcard-headless'),

    block('b-page')(

        mode('content-only')(true),

        mode('title')(function() {
            return iget2('p-view-vcard-headless', 'kontaktnaya-informaciya', 'Контактная информация');
        }),

        elem('foot-js').content()(function() {
            var langList = {
                ru: 'ru-RU',
                en: 'en-US',
                tr: 'tr-TR',
                ua: 'uk-UA'
            };

            return (applyNext() || []).concat({
                elem: 'js',
                url: u.formatUrl({
                    host: '//api-maps.yandex.ru',
                    path: '2.1',
                    query: {
                        lang: langList[this.data.lang] || langList.ru,
                        coordorder: 'longlat'
                    }
                })
            });
        })
    )

);

block('p-view-vcard-headless')(

    def()(function() {
        return applyNext({
            'ctx.mapParams': apply('map-params'),
            'ctx.addressString': apply('address-string')
        });
    }),

    mode('map-params')(function() {
        var vcard = this.data.vcard,
            params = {},
            point,
            bounds;

        if (vcard.city && vcard.street) {
            point = vcard.manual_point || vcard.auto_point;
            bounds = vcard.manual_bounds || vcard.auto_bounds;

            if (point && !vcard.manual_point && !/^(exact|number|street|near)$/.test(vcard.auto_precision)) {
                bounds = point = '';
            }

            point && (point !== vcard.auto_point || /exact|number/.test(vcard.auto_precision)) &&
                (params.point = point.split(',').map(parseFloat));

            bounds &&
                (params.bounds = bounds.split(',').map(parseFloat));
        }

        return params;
    }),

    mode('address-string')(function() {
        var vcard = this.data.vcard,
            address = [];

        vcard.street && address.push(iget2('p-view-vcard-headless', 'ul', 'ул.') + ' ' + vcard.street);
        vcard.house && address.push(iget2('p-view-vcard-headless', 'd', 'д.') + ' ' + vcard.house);
        vcard.build && address.push(iget2('p-view-vcard-headless', 'korp', 'корп.') + ' ' + vcard.build);
        vcard.apart && address.push(iget2('p-view-vcard-headless', 'ofis', 'офис') + ' ' + vcard.apart);

        return address.join(', ');
    }),

    addJs()(function() {
        return {
            map: this.ctx.mapParams,
            vcard: {
                name: this.data.vcard.name,
                address: [this.data.vcard.country, this.data.vcard.city].concat(this.ctx.addressString || []).join(', ')
            }
        };
    }),

    content()(function() {
        var data = this.data,
            mapParams = this.ctx.mapParams,
            addressString = this.ctx.addressString,
            vcard = data.vcard,
            banner = data.banner,
            bounds,
            mapQuery;

        vcard.vcard_id && (banner = data.banner || {});

        if (mapParams.point || mapParams.bounds) {
            mapQuery = {};

            bounds = mapParams.bounds;

            if (bounds) {
                mapQuery.ll = [
                    (bounds[0] + bounds[2]) / 2,
                    (bounds[1] + bounds[3]) / 2
                ].join(',');

                mapQuery.spn = [
                    Math.round(100 * (bounds[2] - bounds[0])) / 100,
                    Math.round(100 * (bounds[3] - bounds[1])) / 100
                ].join(',');
            }

            if (vcard.manual_point) {
                mapQuery.pt = vcard.manual_point;
            } else {
                // т.к. карты не понимают скобок в названиях городов, то мы их удаляем вместе с содержимым
                mapQuery.text = encodeURIComponent(
                    vcard.city.replace(/\(.*?\)/, '').trim() + (addressString && ', ' + addressString)
                );
            }
        }

        return [
            {
                elem: 'header',
                country: vcard.country,
                city: vcard.city
            },
            {
                elem: 'preview',
                vcard: vcard,
                banner: banner
            },
            vcard.phone0 && {
                elem: 'phone',
                country: vcard.country_code,
                city: vcard.city_code,
                phone: vcard.phone0,
                ext: vcard.ext
            },
            vcard.contactperson && {
                elem: 'person',
                content: u.escapeHTML(vcard.contactperson)
            },
            vcard.worktimes && vcard.worktimes.length ?
                {
                    elem: 'worktimes',
                    worktimes: vcard.worktimes
                } :
                '',
            vcard.contact_email && {
                elem: 'email',
                email: vcard.contact_email
            },
            vcard.im_client && vcard.im_login && {
                elem: 'im',
                client: vcard.im_client,
                login: vcard.im_login
            },
            addressString && {
                elem: 'address',
                content: [
                    {
                        elem: 'label',
                        content: [iget2('p-view-vcard-headless', 'adres', 'Адрес'), ':']
                    },
                    {
                        elem: 'info',
                        content: u.escapeHTML(addressString)
                    }
                ]
            },
            vcard.metro && vcard.metro_name ?
                {
                    elem: 'metro',
                    content: [
                        {
                            elem: 'label',
                            content: [iget2('p-view-vcard-headless', 'metro', 'Метро'), ':']
                        },
                        {
                            elem: 'info',
                            content: u.escapeHTML(vcard.metro_name)
                        }
                    ]
                } :
                '',
            mapQuery && [
                {
                    elem: 'ymap'
                },
                {
                    block: 'link',
                    mix: [{
                        block: 'p-view-vcard-headless',
                        elem: 'map-link'
                    }],
                    attrs: {
                        target: '_blank'
                    },
                    url: u.formatUrl({
                        protocol: 'http',
                        host: 'maps.' + data.yandex_domain,
                        query: mapQuery
                    }),
                    content: iget2('p-view-vcard-headless', 'pereyti-na-yandeks-karty', 'Перейти на Яндекс.Карты')
                }
            ],
            vcard.org_details && vcard.org_details.ogrn && !/yandex.com.tr/.test(data.yandex_domain) && {
                elem: 'ogrn',
                content: [
                    {
                        elem: 'label',
                        content: [iget2('p-view-vcard-headless', 'ogrn-ogrnip', 'ОГРН / ОГРНИП'), ':']
                    },
                    {
                        elem: 'info',
                        content: u.escapeHTML(vcard.org_details.ogrn)
                    }
                ]
            }
        ];
    }),

    elem('header').content()(function() {
        return [
            {
                elem: 'region',
                content: [u.escapeHTML(this.ctx.country), ', ', u.escapeHTML(this.ctx.city)]
            },
            {
                block: 'p-view-vcard-headless',
                elem: 'print-button',
                content: [
                    {
                        block: 'b-icon',
                        mods: {
                            type: 'print'
                        },
                        mix: [{
                            block: 'p-view-vcard-headless',
                            elem: 'print-button-icon'
                        }]
                    },
                    {
                        block: 'link',
                        mods: {
                            pseudo: 'yes'
                        },
                        content: iget2('p-view-vcard-headless', 'napechatat', 'Напечатать')
                    }
                ]
            }
        ];
    }),

    elem('preview').content()(function() {
        var vcard = this.ctx.vcard,
            banner = this.ctx.banner;

        banner.title = banner.templ_title || banner.title || iget2('p-view-vcard-headless', 'zagolovok', 'Заголовок');
        banner.body = banner.templ_body || banner.body || iget2('p-view-vcard-headless', 'tekst-obyavleniya', 'Текст объявления');
        banner.domain = banner.domain;
        //DIRECT-38742
        banner.href = banner.href || this.data.FORM.href || banner.domain || '';

        return [
            !!vcard.name && {
                elem: 'vcard-name',
                name: vcard.name
            },
            !!vcard.extra_message && {
                elem: 'extra-message',
                content: u.splitText(vcard.extra_message)
            },
            banner && {
                block: 'b-banner-preview',
                mix: [{
                    block: 'p-view-vcard-headless',
                    elem: 'banner-preview'
                }],
                banner: banner,
                hideSitelinks: true,
                hideVcardDetails: true,
                hideAdWarnings: true,
                geoNames: banner.geo_names,
                geoIds: banner.geo
            }
        ];
    }),

    elem('phone').content()(function() {
        return [
            {
                elem: 'label',
                content: [iget2('p-view-vcard-headless', 'telefon', 'Телефон'), ':']
            },
            {
                elem: 'info',
                content: u.escapeHTML([
                    this.ctx.country,
                    this.ctx.city && '(' + this.ctx.city + ')',
                    this.ctx.phone,
                    this.ctx.ext && iget2('p-view-vcard-headless', 'dob', 'доб.') + this.ctx.ext
                ].filter(function(item) {
                    return !!item;
                }).join(' '))
            }
        ];
    }),

    elem('worktimes').content()(function() {
        return [
            {
                elem: 'label',
                content: [iget2('p-view-vcard-headless', 'vremya-raboty', 'Время работы'), ':']
            },
            {
                elem: 'info',
                content: this.ctx.worktimes.map(function(row) {
                    var days = [],
                        hours = [],
                        label24Hours = iget2('p-view-vcard-headless', 'kruglosutochno', 'круглосуточно');

                    days.push(row.d1);

                    row.d2 && row.d2 !== row.d1 &&
                        days.push(row.d2);

                    row.h2 === '00' && row.m2 === '00' &&
                        (row.h2 = '24');

                    if (row.h1 === '00' && row.h2 === '24' && row.m1 === '00' && row.m2 === '00' ||
                        row.d1 === iget2('p-view-vcard-headless', 'pn', 'пн') && row.d2 === iget2('p-view-vcard-headless', 'vs', 'вс') && row.h1 === row.h2 && row.m1 === row.m2) {

                        row.h1 = label24Hours;
                    }

                    if (row.h1 === label24Hours) {
                        hours.push(row.h1);
                    } else {
                        hours.push([row.h1, row.m1].join(':'));

                        row.h2 && row.m2 &&
                            hours.push([row.h2, row.m2].join(':'));
                    }

                    return {
                        elem: 'worktime',
                        days: days,
                        hours: hours
                    };
                })
            }
        ];
    }),

    elem('email').content()(function() {
        return [
            {
                elem: 'label',
                content: [iget2('p-view-vcard-headless', 'e-mail', 'E-mail'), ':']
            },
            {
                elem: 'info',
                content: u.escapeHTML(this.ctx.email)
            }
        ];
    }),

    elem('im').content()(function() {
        return [
            {
                elem: 'label',
                content: [iget2('p-view-vcard-headless', 'messendzher', 'Мессенджер'), ':']
            },
            {
                elem: 'info',
                client: this.ctx.client,
                login: this.ctx.login
            }
        ];
    }),

    elem('info').content()(function() {
        var messenger = ({
            icq: 'ICQ',
            mail_agent: iget2('p-view-vcard-headless', 'mail-ru-agent', 'Mail.ru Агент'),
            jabber: 'Jabber/GTalk',
            skype: 'Skype',
            MSN: 'MSN'
        })[this.ctx.client];

        return messenger ?
            [
                messenger,
                {
                    block: 'b-icon',
                    mods: {
                        type: u.beminize(this.ctx.client)
                    },
                    mix: [{
                        block: 'p-view-vcard-headless',
                        elem: 'im-icon'
                    }]
                },
                u.escapeHTML(this.ctx.login)
            ] :
            u.escapeHTML(this.ctx.client);
    })
);
