BEM.DOM.decl('p-view-vcard-headless', {

    onSetMod: {
        js: function() {
            var map = this.params.map,
                hasMap = map && !!(map.point || map.bounds);

            hasMap && (this._map = map);

            this.toggleMod(this.elem('ymap'), 'has-map', 'yes', hasMap);
        }
    },

    onElemSetMod: {
        ymap: {
            'has-map': {
                yes: function(elem) {
                    this.afterCurrentEvent(function() {
                        window.ymaps.ready(function() {
                            var children = this.__self.doc.children(),
                                waitFor = function(predicate, callback, retryCount) {
                                    typeof retryCount !== 'number' && (retryCount = 1000);

                                    predicate() && retryCount > 0 || retryCount === 0 ?
                                        callback() :
                                        setTimeout(function() { waitFor(predicate, callback, retryCount - 1); }, 0);
                                };

                            waitFor(
                                function() { return children.is(':visible'); },
                                function() {
                                    this._initMap(
                                        elem,
                                        [this._map.bounds.slice(0, 2), this._map.bounds.slice(2, 4)],
                                        this._map.point);
                                }.bind(this));
                        }, this);
                    }, this);
                }
            }
        }
    },

    /**
     * Инициализирует карту, задает bounds и выставляет метку на карте, если передана
     * @param {jQuery} elem
     * @param {Number[][]} bounds
     * @param {Number[]} [point]
     * @private
     */
    _initMap: function(elem, bounds, point) {
        var ymaps = window.ymaps,
            map = new ymaps.Map(
                elem.get(0),
                ymaps.util.bounds.getCenterAndZoom(bounds, [elem.width(), elem.height()])),
            properties,
            options;

        map.controls.add('zoomControl', { top: 5, left: 5 });

        if (point) {
            properties = {
                balloonContent: this._getMapBalloonContent()
            };

            options = {
                preset: 'twirl#lightblueDotIcon',
                hideIconOnBalloonOpen: true,
                draggable: false
            };

            map.geoObjects.add(new ymaps.Placemark(point, properties, options));
        }
    },

    /**
     * Возвращает контент балуна для метки карты
     * @returns {String}
     * @private
     */
    _getMapBalloonContent: function() {
        return BEMHTML.apply({
            block: 'p-view-vcard-headless',
            elem: 'map-balloon',
            vcard: this.params.vcard
        });
    },

    /**
     * Оповестить заинтересованных о необходимости закрыть документ
     * @private
     */
    _notifyNeedClose: function() {
        BEM.blocks['i-event-bus']
            .getEventBus(window.name)
            .trigger('need-close');
    }

}, {

    live: function() {
        this.liveInitOnBlockInsideEvent('title-click', 'b-banner-preview', function() {
            this._notifyNeedClose();
        });

        this.
            liveBindTo('print-button', 'click', function() {
                window.print();
            })
            .liveBindTo('map-link', 'click', function() {
                this._notifyNeedClose();
            });

        return false;
    }

});
