match(function() {
    return this.data.cmd === 'chooseCountryCurrency';
})(

    block('app-main')(
        mode('page-block')('p-grid'),
        mode('is-footer-enabled')(false),
        mode('is-header-enabled')(false)
    ),

    block('b-page')(
        def().match(function() {
            return !this.pageParams;
        })(function() {
            return applyNext({
                pageParams: {
                    auxParams: {
                        showCampStat: null,
                        camp_count_for_transfer: null,
                        camp_count_with_sum: null,
                        exists_campaigns_for_edit: null,
                        be_shows: null,
                        cid_for_manage_vcards: null,
                        agencyLogin: null,
                        campsExist: null,
                        // данные из cansvn s
                        edit_camp: null,
                        transfer_money: null,
                        payCampaign: null,
                        showuid: null
                    }
                }
            });
        }),

        elem('static-css').replace()(function() {
            return [
                this.addDnaMainStyles()
            ];
        }),

        elem('static-js').replace()(function() {
            var data = this.data,
                nameField = 'name_' + data.lang,
                countries = data.countries.map(function(item) {
                    return {
                        val: item.region_id,
                        text: item[nameField],
                        main: data.main_countries[item.region_id]
                    }
                }),
                svnInfo = data.svn_info || {},
                devInfo = {
                    isBeta: data.is_beta,
                    isProduction: data.is_production,
                    svn: {}
                },
                officeCity = u.getOfficeCityFromData(data),
                officeContacts = applyCtx({ block: 'i-office-contacts' }).offices[officeCity],
                clientCountry = u._.get(data.client_country, 'region_id'),
                clientCurrency = (data.countries_currencies[clientCountry] || [])[0],
                bootstrapParams;

            if (data.is_beta) {
                devInfo.svn = {
                    branch: svnInfo.branch,
                    revision: svnInfo.revision
                };

                devInfo.dbInfo = {
                    configuration: data.CONFIGURATION,
                    shard: data.SHARD
                };

                devInfo.betaNumber = data.server_name.split('.')[0]
            }

            bootstrapParams = {
                availableCampaignsTypes: u['b-choose-campaign-type'].dnaCampaignTypes(),
                clientCountry: clientCountry,
                clientCurrency: clientCurrency,
                cspNonce: data.csp_nonce,
                devInfo: devInfo,
                infoblockTeasersUrl: data.infoblock_teasers_url,
                isShowNewCurrenciesForClientsFromTurkey: data.is_show_new_currencies_for_clients_from_turkey === '1',
                isWebvisorEnabled: data.is_webvisor_enabled,
                login: data.login || data.uname,
                loginFromBlackbox: data.uname,
                officeContacts: officeContacts,
                perlReqId: data.reqid,
                tuneSecretKey: data.tune_secret_key,
                userInfo: u.getUserInfo(data),
                welcomePageParams: {
                    countries: countries,
                    currencyByCountry: data.countries_currencies
                }
            };

            return [
                this.addBeforeJsInitScripts({ observeDOMNode: '#app-wrapper' }),
                this.addUtilityScripts(),
                this.addDnaMainScript(),
                {
                    elem: 'js',
                    content: 'window.dnaBootstrap(' + safeStringify(bootstrapParams) + ')'
                },
                this.addAfterJsInitScripts(),
                this.addCtxDumpScript()
            ];
        }),

        mode('head')(function() {
            return [
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-timing'
                    })
                },
                {
                    elem: 'js',
                    content: applyCtx({
                        block: 'i-rum-error-counter'
                    })
                },
                this.addFavicons()
            ];
        }),

        elem('body').replace()(function() {
            return [
                { elem: 'logos' },
                { elem: 'content' },
                { elem: 'static-css' },
                { elem: 'static-js' }
            ];
        })
    )
);

block('p-welcome')(
    content()(function() {
        return [
            {
                elem: 'app-wrapper',
                attrs: {
                    id: 'app-wrapper',
                    style: 'height: 100vh',
                },
                content: [
                    {
                        block: 'b-header-skeleton'
                    }
                ]
            }
        ];
    })
);
