match(function() {
    return this.data.cmd === 'importCampXLS';
})(

    block('app-main').mode('page-block')('p-xls-import-accept-changes'),

    block('b-page').mode('title')(function() {
        return iget2('p-xls-import-accept-changes', 'upravlenie-kampaniyami-s-pomoshchyu', 'Управление кампаниями с помощью XLS/XLSX');
    })
);

block('p-xls-import-accept-changes')(

    def()(function() {
        return applyNext({
            fileIdentifier: this.data.svars_name && u.escapeHTML(this.data.svars_name)
        });
    }),

    addJs()(true),

    content()(function() {
        return [
            {
                block: 'l-page',
                mods: {
                    layout: '16-60-16'
                },
                content: [
                    {
                        elem: 'row',
                        left: {
                            block: 'b-campaign-menu',
                            options: {
                                navMods: {
                                    type: 'xls'
                                }
                            },
                            mix: [{
                                block: 'p-xls-import-accept-changes',
                                elem: 'text-decorated-menu'
                            }]
                        },
                        center: [
                            {
                                block: 'b-page-title',
                                content: {
                                    elem: 'title',
                                    content: iget2('p-xls-import-accept-changes', 'upravlenie-kampaniyami-s-pomoshchyu', 'Управление кампаниями с помощью XLS/XLSX')
                                }
                            },
                            {
                                block: 'p-xls-import-accept-changes',
                                elem: 'title',
                                elemMods: {
                                    type: this.fileIdentifier ? 'summary' : 'errors'
                                },
                                importFormat: this.data.FORM.import_format
                            },
                            this.fileIdentifier ?
                                {
                                    block: 'p-xls-import-accept-changes',
                                    elem: 'form',
                                    elemMods: {
                                        type: 'summary'
                                    },
                                    action: this.data.script,
                                    userLogin: this.data.user_login,
                                    cid: this.data.cid,
                                    importFormat: this.data.FORM.import_format,
                                    fileIdentifier: this.fileIdentifier,
                                    forAgency: this.data.FORM.for_agency,
                                    requireOfertaAccept: this.data.statusModerate === 'New' &&
                                        this.data.FORM.send_to_moderation,
                                    isGroupFormat: this.data.is_group_format,
                                    isModifyChanges: this.data.FORM.destination_camp === 'old',
                                    changes: this.data.changes,
                                    reservedUnits: this.data.reserved_units,
                                    userUnits: this.data.user_units,
                                    commonWarnings: {
                                        geo: this.data.has_common_geo && !this.data.will_common_geo,
                                        contact: this.data.common_contact_info &&
                                        this.data.common_contact_info.phone && !this.data.will_common_contact_info
                                    },
                                    geoWarnings: this.data.forced_geo_messages,
                                    mergeWarnings: this.data.merge_warnings,
                                    promoCodeWarning: !!this.data.has_promocode_domains
                                } :
                                {
                                    block: 'p-xls-import-accept-changes',
                                    elem: 'form',
                                    elemMods: {
                                        type: 'errors'
                                    },
                                    action: this.data.script,
                                    userLogin: this.data.user_login,
                                    cid: this.data.cid,
                                    importFormat: this.data.FORM.import_format,
                                    errors: [].concat(
                                    this.data.parse_errors || [],
                                    this.data.new_errors || [],
                                    this.data.merge_errors || [],
                                    this.data.errors || [])
                                }
                        ],
                        rgap: true,
                        right: true
                    }
                ]
            }
        ];
    }),

    elem('oferta-iframe').replace()(function() {
        return {
            block: 'b-oferta-accept',
            mix: [{
                block: 'p-xls-import-accept-changes',
                elem: 'oferta-iframe'
            }],
            params: {
                source: 'oferta_direct',
                yandexDomain: this.data.yandex_domain,
                firmId: this.data.client_firm_id
            }
        };
    }),

    elem('form').elemMod('type', 'summary').wrap()(function() {
        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'i-form',
                    mods: {
                        submit: 'bem-event'
                    }
                },
                {
                    block: 'p-xls-import-accept-changes',
                    elem: 'form'
                }
            ],
            method: 'GET',
            action: this.ctx.action,
            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'confirmSaveCampXLS'
                },
                {
                    name: 'import_format',
                    value: this.ctx.importFormat
                },
                {
                    name: 'ulogin',
                    value: this.ctx.userLogin
                },
                {
                    name: 'confirm',
                    value: 1,
                    mods: {
                        disabled: 'yes'
                    },
                    mix: [{
                        block: 'p-xls-import-accept-changes',
                        elem: 'confirm'
                    }]
                },
                this.ctx.cid && {
                    name: 'cid',
                    value: this.ctx.cid
                },
                this.ctx.fileIdentifier && {
                    name: 'svars_name',
                    value: this.ctx.fileIdentifier
                },
                this.ctx.forAgency && {
                    name: 'for_agency',
                    value: this.ctx.forAgency
                }
            ],
            rows: [
                applyCtx({
                    block: 'p-xls-import-accept-changes',
                    elem: 'summary-contents',
                    requireOfertaAccept: this.ctx.requireOfertaAccept,
                    isGroupFormat: this.ctx.isGroupFormat,
                    isModifyChanges: this.ctx.isModifyChanges,
                    changes: this.ctx.changes,
                    reservedUnits: this.ctx.reservedUnits,
                    userUnits: this.ctx.userUnits,
                    commonWarnings: this.ctx.commonWarnings,
                    geoWarnings: this.ctx.geoWarnings,
                    mergeWarnings: this.ctx.mergeWarnings,
                    promoCodeWarning: this.ctx.promoCodeWarning
                })
            ]
        };
    }),

    elem('form').elemMod('type', 'errors').wrap()(function() {
        return {
            block: 'b-layout-form',
            mix: [
                {
                    block: 'i-form',
                    mods: {
                        submit: 'bem-event'
                    }
                },
                {
                    block: 'p-xls-import-accept-changes',
                    elem: 'form'
                }
            ],
            method: 'GET',
            action: this.ctx.action,
            hiddenInputs: [
                {
                    name: 'cmd',
                    value: 'showExportedXlsList'
                },
                this.ctx.cid && {
                    name: 'cid',
                    value: this.ctx.cid
                },
                {
                    name: 'tab',
                    value: this.ctx.importFormat === 'csv' ? 'import_csv' : 'import'
                },
                {
                    name: 'ulogin',
                    value: this.ctx.userLogin
                }
            ],
            rows: [
                applyCtx({
                    block: 'p-xls-import-accept-changes',
                    elem: 'errors-contents',
                    errors: this.ctx.errors
                })
            ]
        };
    }),

    elem('summary-contents').content()(function() {
        return [
            {
                elem: 'changes-list',
                isGroupFormat: this.ctx.isGroupFormat,
                isModifyChanges: this.ctx.isModifyChanges,
                changes: this.ctx.changes
            },
            !!this.ctx.geoWarnings && {
                elem: 'messages',
                messages: this.ctx.geoWarnings
            },
            {
                elem: 'changes-units',
                reservedUnits: this.ctx.reservedUnits,
                userUnits: this.ctx.userUnits
            },
            !!this.ctx.commonWarnings.contact && {
                elem: 'common-warning',
                elemMods: {
                    type: 'contact'
                }
            },
            !!this.ctx.commonWarnings.geo && {
                elem: 'common-warning',
                elemMods: {
                    type: 'geo'
                }
            },
            !!this.ctx.mergeWarnings && {
                elem: 'messages',
                elemMods: {
                    grey: 'yes'
                },
                messages: this.ctx.mergeWarnings
            },
            this.ctx.promoCodeWarning && {
                elem: 'messages',
                elemMods: {
                    grey: 'yes'
                },
                messages: [iget2(
                    'p-xls-import-accept-changes',
                    'promo-code-warning',
                    'У вас действует промокод. При смене или добавлении домена промокод будет аннулирован.'
                )]
            },
            !!this.ctx.requireOfertaAccept && [
                {
                    elem: 'oferta-warnings'
                },
                {
                    elem: 'oferta-iframe'
                }
            ],
            {
                elem: 'buttons',
                content: [
                    {
                        elem: 'cancel-button',
                        content: iget2('p-xls-import-accept-changes', 'otmena', 'Отмена'),
                        type: 'reset'
                    },
                    {
                        elem: 'apply-button',
                        elemMods: this.ctx.requireOfertaAccept && { disabled: 'yes' },
                        content: iget2('p-xls-import-accept-changes', 'primenit', 'Применить'),
                        type: 'submit'
                    }
                ]
            }
        ];
    }),

    elem('errors-contents').content()(function() {
        return [
            {
                elem: 'messages',
                elemMods: {
                    errors: 'yes'
                },
                messages: this.ctx.errors.map(function(error) {
                    return u.escapeHTML(error);
                })
            },
            {
                elem: 'buttons',
                content: [
                    {
                        elem: 'cancel-button',
                        content: iget2('p-xls-import-accept-changes', 'nazad', 'Назад'),
                        type: 'reset'
                    }
                ]
            }
        ];
    }),

    elem('messages').content()(function() {
        return this.ctx.messages.map(function(message) {
            return {
                elem: 'message',
                content: message
            };
        });
    }),

    elem('oferta-warnings').content()(function() {
        return [
            {
                elem: 'accept-warnings',
                elemMods: {
                    highlight: 'yes'
                },
                content: iget2(
                    'p-xls-import-accept-changes',
                    'neobhodimo-podtverdit-soglasie-s',
                    'Необходимо подтвердить согласие с условиями размещения рекламы.'
                )
            },
            {
                elem: 'accept-warnings',
                content: iget2(
                    'p-xls-import-accept-changes',
                    'ya-zakazyvayu-reklamnuyu-kampaniyu',
                    'Я заказываю рекламную кампанию и согласен с условиями размещения рекламы.'
                )
            }
        ];
    }),

    elem('title').elemMod('type', 'summary').content()(function() {
        return [iget2(
            'p-xls-import-accept-changes',
            'v-rezultate-zagruzki-fayla',
            'В результате загрузки файла будут произведены следующие изменения'
        ), ':'];
    }),

    elem('title').elemMod('type', 'errors').content()(function() {
        return this.ctx.importFormat === 'csv' ?
            iget2('p-xls-import-accept-changes', 'pri-obrabotke-csv-obnaruzheny', 'При обработке csv обнаружены ошибки') :
            iget2('p-xls-import-accept-changes', 'pri-obrabotke-fayla-obnaruzheny', 'При обработке файла обнаружены ошибки');
    }),

    elem('changes-units').content()(function() {
        var ctx = this.ctx;

        return iget2(
            'p-xls-import-accept-changes',
            'row-budet-potrachen-budet',
            '{row} {reservedUnits} {firstUnits} из {userUnits} {secondUnits}',
            {
                reservedUnits: ctx.reservedUnits,
                userUnits: ctx.userUnits,

                row: function(text) {
                    return u.pluralizeWord(text.split('|'), ctx.reservedUnits);
                }(
                    iget2('p-xls-import-accept-changes', 'row-budet-potrachen-budet-param-row', 'Будет потрачен|Будет потрачено|Будет потрачено')
                ),

                firstUnits: function(text) {
                    return u.pluralizeWord(text.split('|'), ctx.reservedUnits);
                }(iget2('p-xls-import-accept-changes', 'row-budet-potrachen-budet-param-firstUnits', 'балл|балла|баллов')),

                secondUnits: function(text) {
                    return u.pluralizeWord(text.split('|'), ctx.userUnits);
                }(iget2('p-xls-import-accept-changes', 'row-budet-potrachen-budet-param-secondUnits', 'имеющегося|имеющихся|имеющихся')),

                context: 'row - Будет потрачен|Будет потрачено|Будет потрачено; firstUnits - балл|балла|баллов; secondUnits - имеющегося|имеющихся|имеющихся'
            }
        );
    }),

    elem('common-warning').elemMod('type', 'contact').content()(function() {
        return iget2(
            'p-xls-import-accept-changes',
            'vnimanie-v-kampanii-ustanovlena',
            'Внимание! В кампании установлена единая контактная информация для всех объявлений. При загрузке файла ЕДИНАЯ контактная информация будет отменена.'
        );
    }),

    elem('common-warning').elemMod('type', 'geo').content()(function() {
        return iget2(
            'p-xls-import-accept-changes',
            'vnimanie-v-kampanii-ustanovlen',
            'Внимание! В кампании установлен единый регион для всех объявлений. При загрузке файла ЕДИНЫЙ регион будет отменён.'
        );
    }),

    elem('changes-list').content()(function() {
        var ctx = this.ctx,
            rows = [{
                title: iget2('p-xls-import-accept-changes', 'dobavleno', 'Добавлено'),
                change: 'create'
            }];

        ctx.isModifyChanges && rows.push({
            title: iget2('p-xls-import-accept-changes', 'izmeneno', 'Изменено'),
            change: 'edit'
        }, {
            title: iget2('p-xls-import-accept-changes', 'udaleno', 'Удалено'),
            change: 'remove'
        });

        return rows.map(function(el) {
            // в результате конкатенаций будут получены:
            //  * create_banner create_phrase create_group
            //  * edit_banner edit_phrase edit_group
            //  * remove_banner remove_phrase remove_group
            var data = {
                    banner: ctx.changes[el.change + '_banner'] || 0,
                    phrase: ctx.changes[el.change + '_phrase'] || 0,
                    group: ctx.changes[el.change + '_group'] || 0
                },
                texts = [
                    u.pluralize([iget2('p-xls-import-accept-changes', 'obyavlenie', 'объявление'), iget2('p-xls-import-accept-changes', 'obyavleniya', 'объявления'), iget2('p-xls-import-accept-changes', 'obyavleniy', 'объявлений')], data.banner),
                    u.pluralize([iget2('p-xls-import-accept-changes', 'fraza', 'фраза'), iget2('p-xls-import-accept-changes', 'frazy', 'фразы'), iget2('p-xls-import-accept-changes', 'fraz', 'фраз')], data.phrase),
                    u.pluralize([iget2('p-xls-import-accept-changes', 'gruppa', 'группа'), iget2('p-xls-import-accept-changes', 'gruppy', 'группы'), iget2('p-xls-import-accept-changes', 'grupp', 'групп')], data.group)
                ];

            return {
                elem: 'changes-list-row',
                content: [
                    {
                        elem: 'changes-list-label',
                        content: el.title
                    },
                    {
                        elem: 'changes-list-text',
                        content: texts.filter(function(str) {
                            return !!str;
                        }).join(', ')
                    }
                ]
            };
        });
    }),

    elem('buttons').content()(function() {
        return (this.ctx.content || []).map(function(button) {
            return {
                block: 'button',
                mods: button.mods,
                mix: [{
                    block: 'p-xls-import-accept-changes',
                    elem: button.elem
                }],
                type: button.type,
                content: button.content
            };
        });
    })
);
