BEM.DOM.decl('p-xls-import-accept-changes', {

    onSetMod: {

        js: function() {
            this._ofertaAccept = this.findBlockOn('oferta-iframe', 'b-oferta-accept');
            this._confirmHidden = this.findBlockOn('confirm', 'b-hidden');
            this._form = this.findBlockOn('form', 'i-form');

            this._ofertaAccept && this._ofertaAccept.on('change', function(e, data) {
                this.findBlockOn('apply-button', 'button').toggleMod('disabled', 'yes', data.value !== 'accept');
            }, this);

            this._initEvents();
        }

    },

    /**
     * Блокировка всех контролов формы
     * @private
     */
    _disableControls: function() {
        this._ofertaAccept && this._ofertaAccept.setMod('disabled', 'yes');

        this.findBlocksInside('buttons', 'button').forEach(function(button) {
            button.setMod('disabled', 'yes');
        }, this);
    },

    /**
     * Инициализация событий формы
     * @private
     */
    _initEvents: function() {
        this._form
            // при сабмите формы выставляется хидден поле (снимается атрибут disabled)
            .on('submit', function() {
                // хидден открывается только, если не надо принимать оферту
                // или наоборот надо и она принята
                this._confirmHidden && (!this._ofertaAccept || this._ofertaAccept.val() === 'accept') &&
                    this._confirmHidden.delMod('disabled');

                this._disableControls();

                this._form.submit();
            }, this)

            // при сбросе формы убирает хидден поле (выставляется атрибут disabled)
            // после чего происходит отправка формы
            .on('reset', function() {
                this._confirmHidden && this._confirmHidden.setMod('disabled', 'yes');

                this._disableControls();

                this._form.submit();
            }, this);
    }

});
