match(function() {
    return this.data.cmd === 'importCampSuccess';
})(

    block('app-main').mode('page-block')('p-xls-import-success'),

    block('b-page').mode('title')(function() {
        return iget2('p-xls-import-success', 'upravlenie-kampaniyami-s-pomoshchyu', 'Управление кампаниями с помощью XLS/XLSX');
    })
);

block('p-xls-import-success')(

    tag()(''),

    addJs()(function() {
        return {
            actionUrl: this.data.script
        };
    }),

    content()(function() {
        var form = this.data.FORM;

        return [
            {
                block: 'l-page',
                mods: {
                    layout: '16-80'
                },
                content: [
                    {
                        elem: 'row',
                        left: {
                            block: 'b-campaign-menu',
                            mix: [{
                                block: 'p-xls-import-success',
                                elem: 'text-decorated-menu'
                            }],
                            options: {
                                navMods: {
                                    type: 'xls'
                                }
                            }
                        },
                        right: [
                            {
                                block: 'b-page-title',
                                content: {
                                    elem: 'title',
                                    content: iget2('p-xls-import-success', 'upravlenie-kampaniyami-s-pomoshchyu', 'Управление кампаниями с помощью XLS/XLSX')
                                }
                            },
                            {
                                block: 'p-xls-import-success',
                                elem: 'description',
                                content: [
                                    {
                                        elem: 'description-title'
                                    },
                                    !!+this.data.FORM.make_new_camp && {
                                        elem: 'description-notice'
                                    },
                                    !!+this.data.FORM.has_imagead_jobs && {
                                        block: 'icon-text',
                                        mix: {
                                            block: 'p-xls-import-success',
                                            elem: 'image-notice'
                                        },
                                        mods: {
                                            theme: 'info',
                                            size: 'ms'
                                        },
                                        text: iget2(
                                            'p-xls-import-success',
                                            'izobrazhenie-zagruzhaetsya-ne-srazu',
                                            'Изображение загружается не сразу. Информацию о загрузке можно посмотреть на вкладке {historyLink}.',
                                            {
                                                historyLink: function(text) {
                                                    return {
                                                        block: 'link',
                                                        url: u.getUrl('showExportedXlsList', {
                                                            cid: form.cid,
                                                            ulogin: form.ulogin,
                                                            tab: 'exported_list'
                                                        }),
                                                        content: text
                                                    };
                                                }(iget2('p-xls-import-success', 'izobrazhenie-zagruzhaetsya-ne-srazu-param-historyLink', '"История"')),

                                                context: 'historyLink - "История"'
                                            }
                                        )
                                    },
                                    {
                                        elem: 'description-actions'
                                    }
                                ]
                            }
                        ],
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 2
                                }
                            }
                        }
                    }
                ]
            }
        ];
    }),

    elem('description-title').content()(function() {
        return iget2('p-xls-import-success', 'zagruzka-uspeshno-zavershena', 'Загрузка успешно завершена');
    }),

    elem('description-notice').content()(function() {
        var data = this.data,
            xlsData = data.xls_file_data;

        return iget2(
            'p-xls-import-success',
            'dlya-dalneyshego-upravleniya-kampaniyami',
            'Для дальнейшего управления кампаниями с помощью XLS/XLSX необходимо {download} обновленный файл.',
            {
                download: function(text) {
                    return {
                        block: 'link',
                        url: u.formatUrl({
                            path: '/registered/main.pl' + (xlsData ? xlsData.file_for_url : ''),
                            query: withUidPar({
                                cmd: 'exportCampXLS',
                                xls_format: data.FORM.import_format && data.FORM.import_format == 'xlsx' ? 'xlsx' : 'xls',
                                cid: u.escapeHTML(data.FORM.cid)
                            })
                        }),
                        content: text
                    };
                }(iget2('p-xls-import-success', 'dlya-dalneyshego-upravleniya-kampaniyami-param-download', 'скачать')),

                context: 'download - скачать'
            }
        );
    }),

    elem('description-actions').content()(function() {
        var FORM = this.data.FORM,
            isXlsType = !FORM.import_format || FORM.import_format != 'csv';

        return [
            {
                block: 'button',
                mix: [{
                    block: 'p-xls-import-success',
                    elem: 'continue'
                }],
                js: {
                    formParams: withUidPar({
                        cmd: 'showExportedXlsList',
                        tab: isXlsType ? 'import' : 'import_csv'
                    })
                },
                content: isXlsType ?
                    iget2('p-xls-import-success', 'prodolzhit-rabotu-s-xls', 'Продолжить работу с XLS/XLSX-файлами') :
                    iget2('p-xls-import-success', 'prodolzhit-rabotu-s-csv', 'Продолжить работу с CSV файлами')
            },
            {
                block: 'button',
                mix: [{
                    block: 'p-xls-import-success',
                    elem: 'go-to-campaign'
                }],
                js: {
                    formParams: withUidPar({
                        cmd: FORM.make_new_camp ?
                            'editCamp' : FORM.to_mediaplan ? 'showMediaplan' : 'showCamp',

                        for_agency: FORM.make_new_camp && FORM.for_agency ? FORM.for_agency : undefined,
                        cid: u.escapeHTML(FORM.cid)
                    })
                },
                content: iget2('p-xls-import-success', 'pereyti-v-kampaniyu', 'Перейти в кампанию')
            }
        ];
    })
);
