block('p-xls-management').elem('export')(

    def()(function() {
        var data = this.data,
            cid = data.cid,
            login = data.user_login,
            campaigns = data.camps_name_only || [];

        cid && campaigns.some(function(campaign) {
            return campaign.cid == cid && (campaign.selected = true);
        });

        return applyNext({
            login: login,
            campaigns: campaigns
        });
    }),

    js()(function() {
        return !!this.campaigns.length && {
            xlsAllowedMap: this.campaigns.reduce(function(params, campaign) {
                params[campaign.cid] = +campaign.is_xls_allow;

                return params;
            }, {})
        };
    }),

    match(function() {
        return !this.campaigns.length;
    }).content()(function() {
        return {
            block: 'p-xls-management',
            elem: 'empty-export-list',
            content: iget2('p-xls-management', 'net-dostupnyh-dlya-vygruzki', 'Нет доступных для выгрузки кампаний')
        };
    }),

    match(function() {
        return this.campaigns.length;
    }).content()(function() {
        return {

            block: 'b-layout-form',

            mods: {
                layout: '27-71'
            },

            mixes: {
                row: [{
                    block: 'b-xls-management',
                    elem: 'form-row'
                }],
                label: [{
                    block: 'b-xls-management',
                    elem: 'form-label'
                }],
                control: [{
                    block: 'b-xls-management',
                    elem: 'form-control'
                }],
                submit: [{
                    block: 'b-xls-management',
                    elem: 'form-submit'
                }]
            },

            submit: {
                block: 'button',
                type: 'submit',
                mods: { theme: 'action' },
                content: iget2('p-xls-management', 'vygruzit', 'Выгрузить')
            },

            method: 'GET',

            hiddenInputs: [
                {
                    name: 'ulogin',
                    value: this.login
                },
                {
                    name: 'cmd',
                    value: 'exportCampXLS'
                }
            ],

            rows: [
                {
                    label: iget2('p-xls-management', 'vyberite-kampaniyu', 'Выберите кампанию'),
                    control: {
                        block: 'b-campaigns-select',
                        inputHint: iget2('p-xls-management', 'nayti-po-nomeru-ili', 'Найти по номеру или названию'),
                        emptyHint: iget2('p-xls-management', 'net-kampaniy-sootvetstvuyushchih-filtru', 'Нет кампаний, соответствующих фильтру'),
                        name: 'cid',
                        campaigns: this.campaigns
                    }
                },
                !hasLoginRights('superreader_control') && {
                    label: iget2(
                        'p-xls-management',
                        'posle-vygruzki-vremenno-zablokirovat',
                        'После выгрузки временно заблокировать<br />кампанию для редактирования'
                    ),
                    control: {
                        block: 'checkbox',
                        mods: {
                            size: 's'
                        },
                        checkboxAttrs: {
                            name: 'lock_on_export'
                        }
                    }
                },
                {
                    label: iget2('p-xls-management', 'ne-vygruzhat-arhivnye-obyavleniya', 'Не выгружать архивные объявления'),
                    control: {
                        block: 'checkbox',
                        mods: {
                            size: 's',
                            checked: 'yes'
                        },
                        checkboxAttrs: {
                            name: 'skip_arch'
                        }
                    }
                },
                {
                    label: iget2('p-xls-management', 'format', 'Формат'),
                    control: {
                        block: 'radiobox',
                        mods: {
                            size: 's'
                        },
                        mix: [{
                            block: 'p-xls-management',
                            elem: 'export-format'
                        }],
                        name: 'xls_format',
                        value: 'xls',
                        content: ['xls', 'xlsx'].map(function(format) {
                            return {
                                elem: 'radio',
                                elemMods: { format: format },
                                controlAttrs: {
                                    value: format
                                },
                                content: ['.', format.toUpperCase()]
                            };
                        })
                    }
                }
            ]

        };
    })
);
