BEM.DOM.decl({ block: 'p-xls-management', elem: 'export' }, {

    /**
     * Радиокнопки выбора формата
     */
    _formatRadiobox: null,

    /**
     * Селект со списком кампаний
     */
    _campaignsSelect: null,

    /**
     * Карта cid:флаг для указания, кампании с какими идентификаторами доступны для скачивания в XLS
     */
    _xlsAllowedMap: null,

    onSetMod: {
        js: function() {
            this._formatRadiobox = this.elemInstance('export-format').findBlockOn('radiobox');
            this._campaignsSelect = this.findBlockInside('b-campaigns-select').findBlockOn('select');
            this._campaignsSelect.on('change', this.manageImportFormat, this);

            this._xlsAllowedMap = this.params.xlsAllowedMap;

            this.manageImportFormat();
        }
    },

    /**
     * Проверяет доступный для выгрузки формат и выключает формат XLS, если кампания доступна только в XLSX
     */
    manageImportFormat: function() {
        var formatRadiobox = this._formatRadiobox,
            isXlsAllowed = !!this._xlsAllowedMap[this._campaignsSelect.val()];

        formatRadiobox.setMod(formatRadiobox.elem('radio', 'format', 'xls'), 'disabled', isXlsAllowed ? '' : 'yes');

        isXlsAllowed || formatRadiobox.val('xlsx');
    }

});
