match(function() {
    return this.data.cmd === 'showExportedXlsList';
})(

    block('app-main').mode('page-block')('p-xls-management'),

    block('b-page').mode('title')(function() {
        return iget2('p-xls-management', 'upravlenie-kampaniyami-s-pomoshchyu', 'Управление кампаниями с помощью XLS/XLSX');
    })
);

block('p-xls-management')(

    def()(function() {
        var tabs2blocks = {
                export: 'export',
                import: 'import-xls',
                import_csv: 'import-csv',
                exported_list: 'history'
            },
            tab = tabs2blocks[this.data.FORM.tab || (this.data.FORM.tab = 'export')],
            xlsQueryParams = {
                cmd: 'exportSampleCamp',
                ulogin: u.escapeHTML(this.data.user_login)
            };

        return applyNext({
            xlsQueryParams: xlsQueryParams,
            pageParams: {
                tab: tab,
                showStorageLife: tab === 'history',
                showCurrentBalance: ['import-csv', 'import-xls'].indexOf(tab) > -1,
                showXLSTitle: ['export', 'import-xls', 'history'].indexOf(tab) > -1,
                showCSVTitle: 'import-csv' === tab,
                showXLSRules: ['export', 'import-xls'].indexOf(tab) > -1,
                showCSVRules: 'import-csv' === tab
            }
        });
    }),

    content()(function() {
        return [
            {
                block: 'l-page',
                mods: {
                    layout: '16-80'
                },
                mix: [{
                    block: 'p-xls-management',
                    elem: 'header'
                }],
                content: [
                    {
                        elem: 'row',
                        left: {
                            block: 'b-campaign-menu',
                            mix: [{
                                block: 'p-xls-management',
                                elem: 'text-decorated-menu'
                            }],
                            options: {
                                navMods: {
                                    type: 'xls'
                                }
                            }
                        },
                        right: [
                            {
                                block: 'b-page-title',
                                content: {
                                    elem: 'title',
                                    content: iget2('p-xls-management', 'upravlenie-kampaniyami-s-pomoshchyu', 'Управление кампаниями с помощью XLS/XLSX')
                                }
                            },
                            {
                                block: 'p-xls-management',
                                elem: 'description',
                                content: [
                                    {
                                        elem: 'description-title'
                                    },
                                    {
                                        elem: 'description-notice'
                                    }
                                ]
                            }
                        ],
                        ctxCells: {
                            center: {
                                attrs: {
                                    colspan: 2
                                }
                            }
                        }
                    }
                ]
            },
            {
                block: 'l-page',
                mods: {
                    layout: '16-43-37'
                },
                content: [
                    {
                        elem: 'row',
                        left: '&nbsp',
                        center: {
                            block: 'p-xls-management',
                            elem: 'commander-disclaimer'
                        },
                        right: '&nbsp'
                    },
                    {
                        elem: 'row',
                        left: '&nbsp',
                        center: {
                            block: 'p-xls-management',
                            elem: 'tabs'
                        },
                        right: '&nbsp'
                    },
                    {
                        elem: 'row',
                        left: '&nbsp',
                        center: {
                            block: 'p-xls-management',
                            elem: this.pageParams.tab
                        },
                        right: {
                            block: 'p-xls-management',
                            elem: 'rules-links'
                        }
                    }
                ]
            }
        ];
    }),

    elem('description-title').content()(

        match(function() {
            return this.pageParams.showXLSTitle;
        })({
            elem: 'xls-title'
        }),

        match(function() {
            return this.pageParams.showCSVTitle;
        })({
            elem: 'csv-title'
        })
    ),

    elem('xls-title').content()(function() {
        return iget2(
            'p-xls-management',
            'vy-mozhete-zagruzhat-i',
            'Вы можете загружать и выгружать объявления из рекламных кампаний с помощью файлов формата XLS или XLSX.'
        );
    }),

    elem('csv-title').content()(function() {
        return iget2('p-xls-management', 'vy-mozhete-zagruzhat-obyavleniya', 'Вы можете загружать объявления через CSV-файлы.');
    }),

    elem('commander-disclaimer').content()(function() {
        return [
            {
                elem: 'commander-disclaimer-header',
                tag: 'h3',
                content: iget2('p-xls-management', 'commander-disclaimer-header', 'Установите Директ Коммандер')
            },
            {
                elem: 'commander-disclaimer-description',
                tag: 'p',
                content: iget2(
                    'p-xls-management',
                    'commander-disclaimer-description',
                    'Для эффективного управления масштабными кампаниями и удобной работы с XSLX- и XLS-файлами. Узнайте, как работать с XLS/XLSX файлами в {link}.',
                    {
                        link: {
                            block: 'link',
                            url: 'https://yandex.ru/support/direct-commander-new/advanced/files.html',
                            content: iget2('p-xls-management', 'commander-disclaimer-link', 'Директ Коммандере'),
                            target: '_blank',
                        }
                    }
                )
            },
            {
                block: 'button2',
                mods: {
                    type: 'link',
                    theme: 'normal',
                    size: 's',
                },
                url: 'https://yandex.ru/promo/commander/new',
                text: iget2('p-xls-management', 'commander-disclaimer-btn', 'Скачать приложение'),
                target: '_blank'
            },
            {
                elem: 'commander-disclaimer-logo'
            }
        ]
    }),

    elem('description-notice').content()(

        match(function() {
            return this.pageParams.showStorageLife;
        })({
            elem: 'expires-notice'
        }),

        match(function() {
            return this.pageParams.showCurrentBalance;
        })({
            elem: 'balance-notice'
        })
    ),

    elem('expires-notice').content()(function() {
        return iget2('p-xls-management', 'srok-hraneniya-faylov-s', 'Срок хранения файлов - {foo} дней.', {
            foo: Math.round(this.data.XLS_EXPIRES_DAYS)
        });
    }),

    elem('balance-notice').content()(function() {
        return iget2('p-xls-management', 'tekushchiy-balans-s-ballov', 'Текущий баланс {foo} баллов', {
            foo: this.data.user_units
        });
    }),

    elem('rules-links').content()(

        match(function() {
            return this.pageParams.showXLSRules;
        })({
            elem: 'xls-rules-links'
        }),

        match(function() {
            return this.pageParams.showCSVRules;
        })({
            elem: 'csv-rules-links'
        })
    ),

    elem('xls-rules-links').content()(function() {
        return [
            {
                block: 'b-help-link',
                mods: {
                    margin: 'no'
                },
                mix: {
                    block: 'p-xls-management',
                    elem: 'floating-link'
                },
                url: u.getCommonHelpUrl('/direct/campaigns/xls-interface.xml'),
                text: iget2('p-xls-management', 'pravila-raboty-s-kampaniyami', 'Правила работы с кампаниями через XLS/XLSX')
            },
            {
                block: 'link',
                mix: {
                    block: 'p-xls-management',
                    elem: 'floating-link'
                },
                url: u.formatUrl({
                    path: 'public/direct_example.xls',
                    query: this.xlsQueryParams
                }),
                content: iget2('p-xls-management', 'shablon-xls-fayla', 'Шаблон XLS-файла')
            },
            {
                block: 'link',
                mix: {
                    block: 'p-xls-management',
                    elem: 'floating-link'
                },
                url: u.formatUrl({
                    path: 'public/direct_example.xlsx',
                    query: this.xlsQueryParams
                }),
                content: iget2('p-xls-management', 'shablon-xlsx-fayla', 'Шаблон XLSX-файла')
            }
        ];
    }),

    elem('csv-rules-links').content()(function() {
        return {
            block: 'b-help-link',
            mods: {
                margin: 'no'
            },
            mix: {
                block: 'p-xls-management',
                elem: 'floating-link'
            },
            url: u.getHelpUrl('csv-import'),
            text: iget2('p-xls-management', 'pravila-zagruzki-kampaniy-iz', 'Правила загрузки кампаний из CSV-файлов')
        };
    })
);
