block('p-ya-agency-promo')(
    def()(function() {
        return applyNext({
            lang: this.ctx.lang
        });
    }),

    js()(function() {
        return {
            country: this.ctx.country,
            currency: this.ctx.currency,
            finalText: apply('final-text')
        };
    }),

    content()(function() {
        return [
            { elem: 'top' },
            { elem: 'description' },
            { elem: 'how-it-works' },
            { elem: 'pricing' },
            { elem: 'form' },
            applyNext(),
            { elem: 'final-message' }
        ];
    }),

    elem('final-message').content()(function() {
        return {
            block: 'modal',
            mods: {
                theme: 'normal'
            },
            mix: {
                block: 'p-ya-agency-promo',
                elem: 'modal'
            },
            content: {
                block: 'p-ya-agency-promo',
                elem: 'final-message-text',
                content: apply('final-text')
            }
        };
    }),

    mode('final-text')(function() {
        return !this.ctx.ClientID ?
            iget2('p-ya-agency-promo', 'zayavka-otpravlena-ozhidayte-otveta', 'Заявка отправлена! Ожидайте ответа вашего менеджера.') :
            iget2(
                'p-ya-agency-promo',
                'zayavka-otpravlena-ozhidayte-otveta2',
                'Заявка отправлена! Ожидайте ответа вашего менеджера.<br/>Обратите внимание, что на время настройки кампаний, <br/>доступ в интерфейс для вас будет временно закрыт.<br/>Поэтому проверьте заранее, что у вас нет активных кампаний.'
            )
    }),

    elem('top').content()(function() {
        return [
            { elem: 'headline' },
            { elem: 'brief-description-wrapper' }
        ];
    }),

    elem('description')(
        content()(function() {
            return [
                iget2('p-ya-agency-promo', 'dlya-kazhdogo-klienta-my', 'Для каждого клиента мы продумываем:'),
                {
                    elem: 'description-list',
                    content: [
                        {
                            elem: 'description-list-item',
                            content: iget2('p-ya-agency-promo', 'po-kakim-zaprosam-luchshe', 'по каким запросам лучше показывать рекламу,')
                        },
                        {
                            elem: 'description-list-item',
                            content: iget2('p-ya-agency-promo', 'kak-isklyuchit-pokazy-necelevoy', 'как исключить показы нецелевой аудитории,')
                        },
                        {
                            elem: 'description-list-item',
                            content: iget2('p-ya-agency-promo', 'o-chem-govorit-v', 'о чем говорить в текстах объявлений, чтобы по ним чаще переходили на сайт,')
                        },
                        {
                            elem: 'description-list-item',
                            content: iget2(
                                'p-ya-agency-promo',
                                'kakie-dopolnitelnye-elementy-sdelayut',
                                'какие дополнительные элементы сделают рекламу еще привлекательнее.'
                            )
                        }
                    ]
                }
            ];
        })
    ),

    elem('description-list').tag()(function() {
        return 'ul';
    }),

    elem('description-list-item').tag()(function() {
        return 'li';
    }),

    elem('headline').content()(function() {
        return [
            { elem: 'headline-logo' },
            { elem: 'headline-menu' },
            { elem: 'headline-icon' }
        ];
    }),

    elem('headline-logo').content()(function() {
        return [
            {
                block: 'link',
                mods: { theme: 'direct' },
                mix: {
                    block: 'p-ya-agency-promo',
                    elem: 'headline-logo-yandex'
                },
                url: this['i-services'].serviceUrl('www'),
                content: iget2('p-ya-agency-promo', 'yandeks', 'Яндекс')
            },
            {
                block: 'link',
                mods: { theme: 'direct' },
                mix: {
                    block: 'p-ya-agency-promo',
                    elem: 'headline-logo-direct'
                },
                url: '/',
                content: iget2('p-ya-agency-promo', 'direkt', 'Директ')
            }
        ];
    }),

    elem('headline-menu').content()(function() {
        return [
            {
                elem: 'headline-menu-item',
                js: { name: 'how-it-works' },
                elemMods: { active: 'yes' },
                content: iget2('p-ya-agency-promo', 'kak-eto-rabotaet', 'Как это работает')
            },
            {
                elem: 'headline-menu-item',
                js: { name: 'pricing' },
                content: iget2('p-ya-agency-promo', 'skolko-stoit', 'Сколько стоит')
            }
        ];
    }),

    elem('brief-description-wrapper').content()(function() {
        return {
            elem: 'brief-description',
            content: [
                {
                    elem: 'brief-description-title',
                    mix: { block: 'p-ya-agency-promo', elem: 'brief-description-line' },
                    content: iget2('p-ya-agency-promo', 'pervaya-kampaniya-bez-usiliy', 'Первая кампания без усилий')
                },
                {
                    elem: 'brief-description-content',
                    mix: { block: 'p-ya-agency-promo', elem: 'brief-description-line' },
                    content: iget2(
                        'p-ya-agency-promo',
                        'podgotovim-dlya-vas-pervuyu',
                        'Подготовим для вас первую рекламную кампанию ― с нуля и с учетом специфики вашего бизнеса. А еще расскажем, как управлять рекламой в Директе, чтобы получить больше клиентов.'
                    )
                },
                {
                    block: 'p-ya-agency-promo',
                    elem: 'brief-description-line',
                    content: [
                        {
                            block: 'button',
                            mix: [
                                { block: 'p-ya-agency-promo', elem: 'button' },
                                { block: 'p-ya-agency-promo', elem: 'leave-application' },
                                {
                                    block: 'b-metrika',
                                    js: { goal: 'SETUPSERV_HERO_REQ', counter: '34' }
                                }
                            ],
                            mods: {
                                theme: 'action',
                                size: 'l'
                            },
                            content: iget2('p-ya-agency-promo', 'ostavit-zayavku', 'Оставить заявку')
                        },
                        {
                            elem: 'brief-description-phone'
                        }
                    ]
                }
            ]
        };
    }),

    elem('brief-description-phone').replace()(function() {
        return {
            block: 'link',
            mix: [
                { block: 'p-ya-agency-promo', elem: 'brief-description-line' },
                { block: 'p-ya-agency-promo', elem: 'brief-description-phone' }
            ],
            url: 'tel:88002342480',
            content: '8 800 234-24-80'
        };
    }),

    elem('how-it-works').replace()(function() {
        return [
            {
                block: 'p-ya-agency-promo',
                elem: 'section-title',
                elemMods: { name: 'how-it-works' },
                content: iget2('p-ya-agency-promo', 'kak-eto-rabotaet', 'Как это работает')
            },
            {
                block: 'b-ya-agency-promo-how-it-works',
                mix: { block: 'p-ya-agency-promo', elem: 'how-it-works' }
            }
        ];
    }),

    elem('pricing').replace()(function() {
        return [
            {
                block: 'p-ya-agency-promo',
                elem: 'section-title',
                elemMods: { name: 'pricing' },
                content: iget2('p-ya-agency-promo', 'skolko-stoit', 'Сколько стоит')
            },
            {
                block: 'b-ya-agency-promo-pricing',
                mix: { block: 'p-ya-agency-promo', elem: 'pricing' }
            }
        ];
    }),

    elem('form').content()(function() {
        return [
            {
                block: 'p-ya-agency-promo',
                elem: 'section-title',
                elemMods: { name: 'form' },
                content: iget2('p-ya-agency-promo', 'ostavte-zayavku', 'Оставьте заявку')
            },
            {
                block: 'b-ya-agency-promo-form',
                mix: [
                    { block: 'p-ya-agency-promo', elem: 'form-per-se' },
                    { block: 'i-form', mods: { submit: 'bem-event' } }
                ],
                content: [
                    {
                        block: 'button',
                        type: 'submit',
                        mix: [
                            { block: 'p-ya-agency-promo', elem: 'button' },
                            { block: 'p-ya-agency-promo', elem: 'submit-application' },
                            {
                                block: 'b-metrika',
                                js: { goal: 'SETUPSERV_FORM_REQ', counter: '34' }
                            }
                        ],
                        mods: {
                            theme: 'action',
                            size: 'l'
                        },
                        content: iget2('p-ya-agency-promo', 'otpravit-zayavku', 'Отправить заявку')
                    },
                    { block: 'p-ya-agency-promo', elem: 'disclaimer' },
                ]
            }
        ];
    }),

    elem('disclaimer').content()(function() {
        return iget2(
            'p-ya-agency-promo',
            'nazhimaya-na-knopku-vy',
            'Нажимая на кнопку, вы даете согласие на использование ваших персональных данных и принимаете {service-rules}.',
            {
                'service-rules': function(text) {
                    return {
                        block: 'link',
                        mix: {
                            block: 'b-metrika',
                            js: { goal: 'SETUPSERV_OFFER_LINK', counter: '34' }
                        },
                        url: '//yandex.ru/legal/oferta_yandex_direct_set_up_service',
                        content: text
                    };
                }(
                    iget2('p-ya-agency-promo', 'nazhimaya-na-knopku-vy-param-service-rules', 'оферту на оказание услуг "Настройка Яндекс.Директа"')
                ),

                context: 'service-rules - оферту на оказание услуг "Настройка Яндекс.Директа"'
            }
        );
    })
);
