BEM.DOM.decl('p-ya-agency-promo', {
    onSetMod: {
        js: function() {
            this._form = this.findBlockOn('form-per-se', 'i-form');
            this._pricing = this.findBlockOn('pricing', 'b-ya-agency-promo-pricing');
            this._button = this.findBlockOn('submit-application', 'button');
            this._modal = this.findBlockOn('modal', 'modal');

            this.findBlockOn('leave-application', 'button').on('click', function() {
                this._onLeaveApplicationClick();
            }, this);

            this._form.on('submit', function() {
                this._onSubmitApplication();
            }, this);

            this.bindTo('headline-menu-item', 'click', function(e) {
                if (e.data.domElem.is(e.target)) {
                    var elemParams = this.elemParams(e.data.domElem),
                        itemName = elemParams.name;

                    this._onHeadMenuClick(itemName);
                }
            });

            BEM.blocks['b-metrika2'].params(
                {
                    params: {
                        'ya-agency-promo': {
                            from: this.params.from
                        }
                    }
                }
            );
        }
    },

    /**
     * Плавно прокручивает страницу до указанного элемента
     * @param {jQuery} elem
     * @param {Function} onComplete
     */
    _scrollToElem: function(elem, onComplete) {
        $('body,html').animate({
            scrollTop: elem.offset().top
        },{
            duration: 300,
            complete: onComplete || function() {}
        });
    },

    /**
     * Реакция на клик по кнопке "Оставить заявку"
     */
    _onLeaveApplicationClick: function() {
        var form = this.findBlockOn('form-per-se', 'b-ya-agency-promo-form');

        this._scrollToElem(this.elem('form'), function() {
            form.findBlockInside('input').elem('control').focus();
        });
    },

    /**
     * Реакция на сабмит формы
     */
    _onSubmitApplication: function() {
        var data = this._form.serialize(),
            request = BEM.create('i-direct-request'),
            modal = this._modal,
            button = this._button,
            finalText = this.params.finalText;

        data.cmd = 'ajaxCreateAgencyClient';
        data.order_type = this._pricing.getSelectedPlan();
        data.country = this.params.country;
        data.currency = this.params.currency;

        button.setMod('disabled', 'yes');

        request.get(data)
            .then(function(data) {
                var message = data.error || finalText;

                if (data.error) {
                    button.delMod('disabled');
                } else {
                    BEM.blocks['b-metrika2'].params(
                        {
                            params: {
                                'ya-agency-promo': {
                                    RequestSent: true
                                }
                            }
                        }
                    );
                }

                modal
                    .setMod('autoclosable', data.error ? 'yes' : '')
                    .setContent(BEMHTML.apply({
                        block: 'p-ya-agency-promo',
                        elem: 'final-message-text',
                        content: message
                    }))
                    .setMod('visible', 'yes');
            })
            .catch(function() {
                BEM.blocks['b-user-dialog'].alert(iget2(
                    'p-ya-agency-promo',
                    'ne-udalos-otpravit-zayavku',
                    'Не удалось отправить заявку. Пожалуйста, попробуйте отправить заявку позже.'
                ));
            });
    },

    /**
     * Реакция на клик по пункту меню в шапке
     * @param {String} itemName
     */
    _onHeadMenuClick: function(itemName) {
        this._scrollToElem(this.elem('section-title', 'name', itemName));
    }
});
