match(function() {
    return this.data.cmd === 'showCampsYaMoney';
})(

    block('app-main').mode('page-block')('p-ya-money-payment'),

    block('b-page').mode('title')(function() {
        return iget2('p-ya-money-payment', 'oplata-yandeks-dengami', 'Оплата Яндекс.Деньгами');
    })
);

block('p-ya-money-payment')(

    content()(function() {
        return {
            block: 'l-page',
            mods: {
                layout: '84'
            },
            content: [
                {
                    elem: 'row',
                    center: true,
                    ctxCells: {
                        center: {
                            content: {
                                block: 'p-ya-money-payment',
                                elem: 'title-wrap',
                                content: [
                                    {
                                        block: 'b-page-title',
                                        title: iget2('p-ya-money-payment', 'oplata-yandeks-dengami', 'Оплата Яндекс.Деньгами')
                                    },
                                    {
                                        block: 'b-ya-money-balance',
                                        mods: {
                                            hidden: 'yes'
                                        }
                                    }
                                ]
                            },
                            mix: [{
                                block: 'p-ya-money-payment',
                                elem: 'centered-cell'
                            }]
                        }
                    }
                },
                {
                    elem: 'row',
                    center: true,
                    ctxCells: {
                        center: {
                            content: {
                                block: 'p-ya-money-payment',
                                elem: 'error'
                            },
                            mix: [{
                                block: 'p-ya-money-payment',
                                elem: 'centered-cell'
                            }]
                        }
                    }
                },
                applyCtx({
                    block: 'p-ya-money-payment',
                    elem: 'campaigns-list'
                })
            ]
        };
    }),

    elem('campaigns-list').def()(function() {

        if (this.data.pay_yamoney_error || !this.data.campaigns || !this.data.campaigns.length) return;

        var walletEnabled = this.data.campaigns[0].wallet_is_enabled;

        return {
            elem: 'row',
            center: true,
            ctxCells: {
                center: {
                    content: walletEnabled ?
                        applyCtx({ block: 'b-ya-money-wallet-payment' }) :
                        applyCtx({ block: 'b-ya-money-payment' }),

                    mix: walletEnabled ? [{
                        block: 'p-ya-money-payment',
                        elem: 'centered-cell'
                    }] : []
                }
            }
        };
    }),

    elem('error').content()(function() {
        var data = this.data,
            notAvailableText = iget2('p-ya-money-payment', 'k-sozhaleniyu-oplata-yandeks', 'К сожалению, оплата Яндекс.Деньгами не доступна.'),
            error = [];

        if (!data.pay_yamoney_error) {
            if (!data.campaigns || !data.campaigns[0] || !data.campaigns[0].wallet_is_enabled) {
                error.push({
                    block: 'b-overdraft'
                });
            }

            if (data.error || data.FORM.error_code) {
                if (data.error) {
                    error.push({
                        block: 'b-header',
                        content: data.error
                    });
                }

                data.pay_error_text && error.push({
                    elem: 'pay-error',
                    content: u.escapeHTML(data.pay_error_text)
                });
            }

            if (data.campaigns.length < 1) {
                error.push({
                    elem: 'info',
                    content: iget2('p-ya-money-payment', 'u-vas-net-reklamnyh', 'У вас нет рекламных кампаний, доступных для оплаты.')
                });
            }
        } else if (data.pay_yamoney_error == 'currency') {
            error.push({
                elem: 'common-error',
                content: iget2(
                    'p-ya-money-payment',
                    'k-sozhaleniyu-oplata-yandeks-107',
                    'К сожалению, оплата Яндекс.Деньгами не доступна для аккаунта в {foo}.',
                    {
                        foo: u.currencies.getName(data.work_currency)
                    }
                )
            });
        } else if (data.pay_yamoney_error == 'country') {
            error.push({
                elem: 'common-error',
                content: notAvailableText
            });

        } else {
            error.push({
                elem: 'info',
                content: notAvailableText
            });
        }

        return error;
    })
);
