/**
 * this.ctx.dedalId {number} Идентификатор сделки
 * this.ctx.client {string} Логин клиента
 * this.ctx.employedClients {string[]} Логины остальных клиентов, кампании которых уже привязаны к сделке
 * this.ctx.campaigns {{campaignId:number, campaignName:string}[]} Привязанные к сделке кампании
 */
block('pd-client-camps-chooser')(

    def()(function() {
        var campaignNamesById = {},
            campaignIds = [],
            campaigns = (this.ctx.campaigns || []).map(function(item) {
                var campaignId = item.campaignId.toString(),
                    campaignName = item.campaignName;

                campaignNamesById[campaignId] = campaignName;
                campaignIds.push(campaignId);

                return {
                    campaignId: campaignId,
                    campaignName: campaignName,
                    userName: item.userName
                };
            });

        return applyNext({
            'mods.initial': this.ctx.client ? '' : 'yes',
            'ctx.campaigns': campaigns,
            'ctx.campaignIds': campaignIds.sort(function(a, b) { return a - b }),
            'ctx.campaignNamesById': campaignNamesById
        })
    }),

    mix()(function() {
        return {
            mods: {
                'client-choosed': this.ctx.client ? 'yes' : 'no',
                client: this.ctx.client
            }
        }
    }),

    js()(function() {
        return u._.pick(this.ctx, ['client', 'campaignIds', 'employedClients', 'dealId', 'campaignNamesById']);
    }),

    content()(function() {
        var ctx = this.ctx,
            campaignIds = ctx.campaignIds,
            campaignNamesById = ctx.campaignNamesById;

        return {
            block: 'b-text-panel',
            content: [
                {
                    elem: 'head',
                    content: [
                        {
                            elem: 'title',
                            content: this.ctx.client
                        },
                        {
                            block: 'pd-client-camps-chooser',
                            elem: 'camps-label',
                            mix: { block: 'b-text-panel', elem: 'subtitle' },
                            campaignsCount: campaignIds.length
                        },
                        {
                            block: 'pd-client-camps-chooser',
                            elem: 'remove'
                        }
                    ]
                },
                {
                    elem: 'content',
                    content: [
                        {
                            block: 'pd-client-camps-chooser',
                            elem: 'camps-chooser',
                            campaignIds: campaignIds
                        },
                        {
                            block: 'pd-client-camps-chooser',
                            elem: 'badges',
                            clientName: this.ctx.client,
                            campaignIds: campaignIds,
                            campaignNamesById: campaignNamesById
                        }
                    ]
                }
            ]
        };
    }),

    mod('initial', 'yes').content()(function() {
        return [
            {
                block: 'dropdown-chooser',
                mods: { theme: 'normal', size: 's', value: 'pd-client' },
                mix: {
                    block: this.block,
                    elem: 'chooser',
                    elemMods: { type: 'clients' }
                }
            },
            {
                block: 'pd-client-camps-chooser',
                elem: 'camps-chooser',
                campaignIds: []
            },
            {
                block: 'pd-client-camps-chooser',
                elem: 'badges',
                campaignIds: [],
                campaignNamesById: {}
            }
        ]

    })

);
