BEM.DOM.decl('pd-client-camps-chooser', {

    onSetMod: {
        js: function() {
            this._clientName = this.params.client;

            this._cids = {
                prev: this.params.campaignIds.reduce(function(res, cid) {
                    return u._.set(res, cid, true);
                }, {}),
                added: {},
                removed: {}
            };
        }
    },

    /**
     * Сообщает о наличии изменений
     * @return {boolean}
     */
    isChanged: function() {
        return !!(Object.keys(this._cids.added).length || Object.keys(this._cids.removed).length);
    },

    /**
     * Возвращает изменения и информация о кампаниях из массива `toAdd`
     * @return {{toAdd: number[], toRemove: number[], addedCampaignsInfo: object}}
     */
    getValue: function() {
        var client = this._clientName,
            campsNameById = this._campsNameById,
            toAddCids = Object.keys(this._cids.added).map(Number);

        return {
            toAdd: toAddCids,
            toRemove: Object.keys(this._cids.removed).map(Number),
            addedCampaignsInfo: toAddCids.reduce(function(res, cid) {
                res[cid] = { campaignId: cid, campaignName: campsNameById[cid], userName: client };

                return res;
            }, {})
        };
    },

    /**
     * Сообщает об изменениях
     * @private
     */
    _reportAboutChanges: function() {
        var isChanged = this.isChanged();

        if (isChanged !== this._prevIsChanged) {
            this._prevIsChanged = isChanged;

            this.trigger('change', { isChanged: isChanged });
        }
    },

    /**
     * Обработчик инициализации блоков `dropdown-chooser`
     * @param {jQuery.Event} e
     * @param {object} data
     * @private
     */
    _onDropdownChooserInit: function(e, data) {
        if (!this.elem('chooser').is(e.block.domElem)) {
            return;
        }

        var dropdownChooser = e.block,
            dropdownChooserType = this.getMod(dropdownChooser.domElem, 'type');

        if (dropdownChooserType === 'clients') {
            dropdownChooser
                .setProvider(this._getClients.bind(this))
                .setBypass(this._getBypassForClients.bind(this))
        } else if (dropdownChooserType === 'campaigns') {
            if (this.hasMod('client-choosed', 'yes')) {
                dropdownChooser.setProvider(this._getCampaigns.bind(this, this._clientName));
            }

            dropdownChooser.setBypass(this._getBypassForCampaigns.bind(this));
        }
    },

    _onDropdownChooserChange: function(e, data) {
        switch (this.getMod(e.block.domElem, 'type')) {
            case 'clients':
                return this._onClientChange(e, data);
            case 'campaigns':
                return this._onCampsChange(e, data);
        }
    },

    /**
     * Обработчик изменения клиента
     * @param {jQuery.Event} e
     * @param {{itemId: string}} data
     * @private
     */
    _onClientChange: function(e, data) {
        var clientName = data.itemId,
            campaignsDropdownChooser = this._getDropdownChooser('campaigns');

        if (clientName) {
            this._removeCampaigns();

            campaignsDropdownChooser
                .setProvider(this._getCampaigns.bind(this, clientName))
                .open();
        } else {
            campaignsDropdownChooser.setProvider(false);
        }

        this.setMod('client-choosed', clientName ? 'yes' : 'no');

        this._clientName = clientName;
    },

    /**
     * Обрабочтк изменений списка кампаний
     * @param {jQuery.Event} e
     * @param {{itemId: string, isSelected:boolean}} data
     * @private
     */
    _onCampsChange: function(e, data) {
        var cid = data.itemId;

        if (data.isSelected) {
            if (this._cids.removed[cid]) {
                this._cids.removed = u._.omit(this._cids.removed, cid);

                this.delMod(this._getBadgeByCid(cid), 'removed');
            } else {
                this._cids.added[cid] = true;

                this._addBadge(cid);
            }
        } else {
            if (this._cids.added[cid]) {
                this._cids.added = u._.omit(this._cids.added, cid);

                this._removeBadge(cid);
            } else {
                this._cids.removed[cid] = true;

                this.setMod(this._getBadgeByCid(cid), 'removed', 'yes');
            }
        }

        this._displayValue();
        this._reportAboutChanges();
    },

    /**
     * Добавляет бейдж с учетом сортировки
     * @param {string} cid
     * @private
     */
    _addBadge: function(cid) {
        var badgeHtml = BEMHTML.apply({
                block: this.__self.getName(),
                elem: 'badge',
                elemMods: { added: 'yes' },
                clientName: this._clientName,
                campaignId: cid,
                campaignName: this._campsNameById[cid]
            }),
            badges = this.findElem('badges', 'badge'),
            currentBagdes = [],
            insertIndex;

        badges.each(function(i, el) {
            var badge = $(el);

            currentBagdes.push({
                cid: +this.getMod(badge, 'cid'),
                domElem: badge
            });
        }.bind(this));

        insertIndex = u._.sortedIndex(currentBagdes, { cid: +cid }, 'cid');

        if (currentBagdes[insertIndex]) {
            BEM.DOM.before(currentBagdes[insertIndex].domElem, badgeHtml)
        } else {
            BEM.DOM.append(this.elem('badges'), badgeHtml);
        }
    },

    /**
     * Удаляет бейдж
     * @param {string} cid
     * @private
     */
    _removeBadge: function(cid) {
        BEM.DOM.destruct(this._getBadgeByCid(cid));
    },

    /**
     * Возвращает бейдж по его идентификатору
     * @param {string} cid
     * @return {jQuery}
     * @private
     */
    _getBadgeByCid: function(cid) {
        return this.findElem('badges', 'badge', 'cid', cid);
    },

    /**
     * Кеширует и возвращает блок `dropdown-chooser` по типу
     * @param {'clients'|'campaigns'} type
     * @private
     */
    _getDropdownChooser: function(type) {
        this._choosers || (this._choosers = {});

        return u._.get(
            this._choosers,
            type,
            u._.set(this._choosers, type, this.findBlockInside(this.elem('chooser', 'type', type), 'dropdown-chooser'))
        );
    },

    /**
     * Обработчик клика по стрелочке
     * @private
     */
    _onTextPanelFoldedChange: function(e, data) {
        this.trigger('edit-mode-change', {
            stateKey: 'clients',
            id: this.params.client,
            isFolded: data.value
        });
    },

    /**
     * Обработчик клика по корзине
     * @private
     */
    _onRemoveClick: function() {
        this.blockInside('b-text-panel').setMod('folded', 'no');

        this._removeCampaigns();
    },

    _removeCampaigns: function() {
        this._cids.removed = u._.assign({}, this._cids.prev);
        this._cids.added = {};

        BEM.DOM.destruct(this.findElem('badges', 'badge', 'added', 'yes'));
        this.setMod(this.findElem('badges', 'badge'), 'removed', 'yes');

        this._getDropdownChooser('campaigns').setValue([]);

        this._displayValue(0);
        this._reportAboutChanges();
    },

    /**
     * Отображает изменение выбранных кампаний в блоке
     * @param {number} [count] итоговое количество кампаний
     * @private
     */
    _displayValue: function(count) {
        if (u._.isUndefined(count)) {
            count = u._.size(this._cids.prev) - u._.size(this._cids.removed) + u._.size(this._cids.added);
        }

        this.setMod(this.elem('remove'), 'disabled', count ? '' : 'yes');

        BEM.DOM.replace(
            this.findElem('camps-label'),
            BEMHTML.apply({
                block: this.__self.getName(),
                mix: { block: 'b-text-panel', elem: 'subtitle' },
                elem: 'camps-label',
                campaignsCount: count
            })
        );
    },

    /**
     * Возвращает промис похода за клиентами
     * @return {Promise<{success:boolean, items: {id:string, name:string, isDisabled:boolean}[]}>}
     * @private
     */
    _getClients: function() {
        var employedClients = this.params.employedClients || [];

        return BEM.blocks['i-web-api-request'].privateDeals.getSubClients(u.consts('ulogin'))
            .then(function(response) {
                if (!response.success) {
                    throw response;
                }

                return u._.get(response, 'result', []);
            })
            .then(function(items) {
                return {
                    success: true,
                    items: items.map(function(item) {
                        return {
                            id: item,
                            name: item,
                            isDisabled: u._.includes(employedClients, item)
                        };
                    })
                };
            })
            .catch(function() {
                return Promise.resolve({ success: false });
            });
    },

    /**
     * Возвращает промис похода за кампаниями
     * @param {string} login логин клиента
     * @return {Promise<{success:boolean, items: {id:string, name:string, addition: string, isDisabled:boolean}[]}>}
     * @private
     */
    _getCampaigns: function(login) {
        return BEM.blocks['i-web-api-request'].privateDeals.getDealCampaigns(login)
            .then(function(response) {
                if (!response.success) {
                    throw response;
                }

                return u._.get(response, 'result', []);
            })
            .then(function(campaigns) {
                this._campsNameById = campaigns.reduce(function(res, camp) {
                    return u._.set(res, camp.id, camp.name);
                }, {});

                return campaigns;
            }.bind(this))
            .then(function(items) {
                var linkedCampaignIds = this.params.campaignIds,
                    campaignNamesById = this.params.campaignNamesById,
                    receivedCampaignIds = [],
                    formattedItems = items.map(function(item) {
                        var cid = item.id.toString();

                        receivedCampaignIds.push(cid);

                        return {
                            id: cid,
                            name: item.name,
                            addition: cid
                        };
                    }),
                    missingCampaignIds = u._.difference(linkedCampaignIds, receivedCampaignIds);

                // Добавляем уже привязанные к сделке кампании, которых не оказалось в списке по каким-либо причиниам,
                // такое возможно когда у кампаниии, например, изменился статус (на текущий момент на любой кроме "Черновик")
                if (missingCampaignIds.length) {
                    formattedItems = formattedItems.concat(
                        missingCampaignIds.map(function(cid) {
                            return {
                                id: cid,
                                name: campaignNamesById[cid],
                                addition: cid,
                                isDisabled: true
                            };
                        })
                    )
                }

                return {
                    success: true,
                    items: formattedItems.sort(function(a, b) { return a.id - b.id })
                };
            }.bind(this))
            .catch(function() {
                return Promise.resolve({ success: false });
            });
    },

    /**
     * Возвращает bemjson с сообщением про список клиентов
     * @param {boolean} [isNetworkError=false]
     * @return {object}
     * @private
     */
    _getBypassForClients: function(isNetworkError) {
        if (isNetworkError) {
            return this._getBypassCommon();
        }

        return {
            block: 'b-emptiness',
            title: iget2('pd-client-camps-chooser', 'emply-clients-list-title', 'Нет ни одного клиента'),
            detail: iget2(
                'pd-client-camps-chooser',
                'emply-clients-list-detail',
                'Убедитесь, что у вас есть клиенты с доступными для привязки кампаниями'
            )
        };
    },

    /**
     * Возвращает bemjson с сообщением про список кампаний
     * @param {boolean} [isNetworkError=false]
     * @return {object}
     * @private
     */
    _getBypassForCampaigns: function(isNetworkError) {
        if (isNetworkError) {
            return this._getBypassCommon();
        }

        return {
            block: 'b-emptiness',
            title: iget2('pd-client-camps-chooser', 'emply-campaigns-list-title', 'Нет ни одной кампании'),
            detail: iget2(
                'pd-client-camps-chooser',
                'emply-campaigns-list-detail',
                'Убедитесь, что у выбранного клиента есть доступные для привязки кампании'
            )
        };
    },

    /**
     * Возвращает bemjson с общим сообщением для списков клиентов и кампаний
     * @return {object}
     * @private
     */
    _getBypassCommon: function() {
        return {
            block: 'b-emptiness',
            title: iget2('pd-client-camps-chooser', 'error-list-title', 'Произошла неизвестная ошибка'),
            detail: iget2(
                'pd-client-camps-chooser',
                'error-list-detail',
                'Пожалуйста, попробуйте позже'
            )
        };
    },

    /**
     * Флаг о наличи реакции на ESC у вложенных блоков
     * @returns {boolean}
     */
    haveReactionToEsc: function() {
        return u._.compact([
            this._getDropdownChooser('clients'),
            this._getDropdownChooser('campaigns')
        ]).some(function(block) {
            return block.haveReactionToEsc();
        });
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('folded', 'b-text-panel', function(e, data) {
                this._onTextPanelFoldedChange(e, data);
            })
            .liveBindTo('remove', 'pointerclick', function(e, data) {
                this._onRemoveClick(e, data);
            })
            .liveInitOnBlockInsideEvent('init', 'dropdown-chooser', function(e, data) {
                this._onDropdownChooserInit(e, data);
            })
            .liveInitOnBlockInsideEvent('change', 'dropdown-chooser', function(e, data) {
                this._onDropdownChooserChange(e, data);
            });
    }

});
