u.register({
    'pd-client-camps-chooser': {

        /**
         * Возвращает текст кнопки (или лейбла) для выбора клиента
         * @param {string} clientName логин выбранного клиента
         * @return {string}
         */
        getTextChooserClient: function(clientName) {
            return clientName ?
                clientName :
                iget2('pd-client-camps-chooser', 'choose-client', 'Выберите клиента');
        },

        /**
         * Возвращает текст кнопки (или лейбла) для выбора кампаний
         * @param {number} count Количество выбранных кампаний
         * @param {boolean} [isControl=false] Текст нужен для контрола
         * @return {string}
         */
        getTextChooserCampaigns: function(count, isControl) {
            return count ?
                u.pluralizeWord(
                    [
                        iget2('pd-client-camps-chooser', 'choosed-1-camp', 'Выбрана {n} кампания', { n: count }),
                        iget2('pd-client-camps-chooser', 'choosed-2-camps', 'Выбрано {n} кампании', { n: count }),
                        iget2('pd-client-camps-chooser', 'choosed-5-camps', 'Выбрано {n} кампаний', { n: count })
                    ],
                    count
                ) :
                isControl ?
                    iget2('pd-client-camps-chooser', 'choose-camps', 'Выберите кампании из списка') :
                    iget2('pd-client-camps-chooser', 'campaigns-are-not-chosen', 'Кампании не выбраны')

        },

        /**
         * Возвращает текст для случая когда поиск кампаний не дал результатов
         * @return {string}
         */
        getEmptySearchCampaigns: function() {
            return {
                title: iget2(
                    'pd-client-camps-chooser',
                    'campaigns-not-found-title',
                    'Не нашлось ни одной кампании'
                ),
                detail: iget2(
                    'pd-client-camps-chooser',
                    'not-found-detail',
                    'Убедитесь, что в запросе нет ошибок или попробуйте уменьшить длину запроса'
                )
            }
        },

        /**
         * Возвращает текст для случая когда поиск клиентов не дал результатов
         * @return {string}
         */
        getEmptySearchClients: function() {
            return {
                title: iget2(
                    'pd-client-camps-chooser',
                    'clients-not-found-title',
                    'Не нашлось ни одного клиента'
                ),
                detail: iget2(
                    'pd-client-camps-chooser',
                    'not-found-detail',
                    'Убедитесь, что в запросе нет ошибок или попробуйте уменьшить длину запроса'
                )
            }
        }
    }
});
