BEM.DOM.decl({
    block: 'popup',
    modName: 'autoclosable',
    modVal: 'yes'
}, {

    /**
     * Проверяет, является ли нода родственной
     * Метод ищет в потомках блока, owner и самом себе
     * Применяется для предотвращения закрытия блока при
     * клике на родственных ему блоках\элементах
     * Так же предотвращает закрытие, если был кликнут элемент в модальном попапе
     * @private
     * @param {jQuery} node - что искать
     * @return {Boolean}
     */
    _isRelatedNode: function(node) {
        // Костыль. Возвращен из старых правок.
        // История проблемы: DIRECT-54179 > DIRECT-55435 > DIRECT-56083
        // Проверяем является ли элемент потомком b-confirm (если кликнуть в тело блока)
        // или самим b-confirm (если кликнуть в отступы блока)
        if (node.parents('.b-confirm.popup_visibility_visible').length ||
                (node.hasClass('b-confirm') && node.hasClass('popup_visibility_visible'))) {
            return true;
        }

        if (node.hasClass('link__inner') && node.parents('.b-group-preview2-opener').length) {
            return false;
        }

        return this.__base.apply(this, arguments);
    }

});
