/**
 * Попап, отключающий body-scroll
 * От стандартного body-scroll отличается _только_ тем,
 * что отключение скроллбара происходит ДО показывания попапа
 * и от этого он не прыгает
 */

(function() {
    var openedPopups = {};
    //https://st.yandex-team.ru/DIRECT-59123#1487248905000
    BEM.DOM.decl({ block: 'popup', modName: 'body-scroll', modVal: 'no' }, {
        onSetMod: {
            js: function() {
                this.__base.apply(this, arguments);

                // так же, как в body-scroll: no, но сначала убираем скролл
                // а потом показываем попап
                this
                    .on('show', function() {
                        openedPopups[this.params.uniqId] = true;
                        this._manageScopeOverflow();
                    }, this)
                    .on('hide', function() {
                        delete openedPopups[this.params.uniqId];
                        this._manageScopeOverflow();
                    });
            }
        },

        destruct: function() {
            var uniqId = this.params.uniqId;

            if (openedPopups[uniqId]) {
                delete openedPopups[uniqId];
                this._manageScopeOverflow();
            }

            this.__base.apply(this, arguments);
        },

        /**
         * Возвращает scroll на область блока.
         *
         * https://st.yandex-team.ru/ISLCOMPONENTS-1069
         *
         * @protected
         * @returns {BEM.DOM} this
         */
        _enableScroll: function() {
            this._scope.css({ overflow: '' });
            return this;
        },

        /**
         * Убирает scroll с области блока.
         *
         * https://st.yandex-team.ru/ISLCOMPONENTS-1069
         *
         * @protected
         * @returns {BEM.DOM} this
         */
        _disableScroll: function() {
            this._scope.css({ overflow: 'hidden' });
            return this;
        },

        /**
         * Ставим скролл, если все попапы убраны
         * Убираем скролл, если появился 1 попап (при появлении остальных скролл и так убран)
         * @private
         */
        _manageScopeOverflow: function() {
            var count = Object.keys(openedPopups).length;

            if (count === 0) {
                this._enableScroll();
            } else if (count === 1) {
                this._disableScroll();
            }
        }
    });
})();
