BEM.DOM.decl({ block: 'popup', modName: 'content-adaptive', modVal: 'yes' }, {

    _onShown: function() {
        this.__base.apply(this, arguments);

        this._toggleListenResizeContent(true);
    },

    _onHidden: function() {
        this._toggleListenResizeContent(false);

        this.__base.apply(this, arguments);
    },

    /**
     * Включает/выключает подписку на изменения размеров попапа
     * @param {Boolean} [enable] Флаг нужного положения
     * @private
     */
    _toggleListenResizeContent: function(enable) {
        var under = this._getUnder();

        if (under.length && under[0].contentWindow) {
            var iframeWindow = $(under[0].contentWindow.window);

            if (enable) {
                this.bindToDomElem(iframeWindow, 'resize', $.debounce(this._onContentResize, 120, this));
            } else {
                this.unbindFromDomElem(iframeWindow, 'resize');
            }
        }
    },

    /**
     * Обработчик изменения размеров контента попапа.
     * Подчищает кэши, инициирует перерисовку блока.
     */
    _onContentResize: function() {
        this._cache = {};

        if (this._isShown && !this._isHiding) {
            this.repaint();
        }
    },

    /**
     * Метод, позволяющий выбрать между `div` и `iframe`
     * @returns {Boolean}
     */
    isDivEnough: function() {
        // заставляем всегда выбирать iframe
        return false;
    },

    destruct: function() {
        this._toggleListenResizeContent(false);

        this.__base.apply(this, arguments);
    }

});
