BEM.DOM.decl({ block: 'popup', modName: 'position', modVal: 'fixed' }, {

    /**
     * Если стоит модификатор on-scroll у дочернего попапа, то включаем слежение за прокруткой страницы.
     *
     * @public
     * @param {BEM.DOM} child Дочерний попап.
     */
    addChild: function(child) {
        this.__base.apply(this, arguments);

        if (child.getMod('on-scroll')) {
            child.setMod('watch-scroll', 'yes');
        }
    }

});

BEM.DOM.decl({ block: 'popup', modName: 'on-scroll', modVal: 'close' }, {

    getScrollEvents: function() {
        var scrollEvents = ['scroll'];

        // В FireFox scroll тригерится даже при ресайзе дом дерева
        if (navigator.userAgent.toLowerCase().indexOf('firefox') > -1) {
            scrollEvents = ['MozMousePixelScroll'];
        }
        return scrollEvents;
    },

    /**
     * Переопределяем действие при скролле, который слушается в модифиакторе `_adaptive_yes`
     */
    onScroll: function() {
        this._cache = {};

        if (this._isShown && !this._isHiding) {
            this.hide();
        }
    }

});
