/**
 * Попап с динамическими размерами.
 *
 * Через определенные интервалы времени автоматически подстраивает размеры
 * попапа под размеры контента.
 */
BEM.DOM.decl({ block: 'popup', modName: 'poll', modVal: 'size' }, {

    /*
     * Переопределение для обнуления ID таймера
     *
     * @protected
     * @override
     */
    _onHidden: function() {
        this.__base.apply(this, arguments);

        this._sizePollInterval = 0;
    },

    /**
     * Перерисовывает попап если его размер изменился.
     *
     * @private
     * @override переопределено для перекрытия 2-ой версии островов
     * @todo https://st.yandex-team.ru/ISL-2353 выпилить переопределение вместе с этим модификатором при переходе на 4-ые острова
     * после выпиливания в DIRECT-60787 обнаружен баг с бесконечным ресайзом
     */
    _sizePoller: function() {
        if (!this._isShown || this._isHiding) {
            return;
        }

        var currSize = this.getPopupSize(),
            currPos = this.getCurrPos(),
            /**
             * Произошло ли изменение значения (с учетом deltaVal)
             * @param {Number|String} prev предыдущее значение в px или %
             * @param {Number|String} curr текущее значение в px или %
             * @returns {Boolean}
             */
            isChangedSize = function(prev, curr) {
                if (typeof prev !== typeof curr) return true;

                /**
                 * Значение дельты, на которое должен измениться хотя бы один показатель измерений попапа для его перерисовки
                 * Для % дельта значима начиная от полпроцента
                 * Для абсолютного значения дельта должна начинатся от 3px,
                 * чтобы не происходил эффекти поддергивания попапа
                 * https://st.yandex-team.ru/DIRECT-84488#1538641671000
                 * @type {Number}
                 */
                var deltaVal = typeof prev === 'string' ? 0.5 : 3;

                return Math.abs(parseFloat(prev) - parseFloat(curr)) > deltaVal;
            },
            isChanged = !this._prevSize || !this._prevPos ||
                isChangedSize(this._prevSize.height, currSize.height) ||
                isChangedSize(this._prevSize.width, currSize.width) ||
                isChangedSize(this._prevPos.left, currPos.left) ||
                isChangedSize(this._prevPos.top, currPos.top);

        if (isChanged) {
            this._prevSize = currSize;
            this._prevPos = currPos;

            this.repaint();
        }
    }
});
