BEM.DOM.decl('popup', {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            // Объявляем свой канал для управления всеми открытыми блоками на странице.
            // Связанно с тем, что в оригинальном блоке popup при закрытии одного блока
            // от канала отписываются все.
            this._directChannel = BEM.channel('direct-popups');
        }
    },

    /**
     * Устанавливает контент блока
     * @param {String|jQuery} content контент
     * @param {Function} [callback] Обработчик, вызываемый после инициализации контента
     * @param {Object} [callbackCtx] контекст обработчика
     * @override
     * @return {BEM}
     */
    setContent: function(content, callback, callbackCtx) {
        BEM.DOM.update(this.elem('content'), content, function(ctx) {
            this._resetDefault();
            this.isShown() && this.repaint();

            callback && this.afterCurrentEvent(function() {
                callback.call(callbackCtx || this, ctx);
            });
        }, this);

        return this;
    },

    /**
     * Обработчик скрытия блока.
     *
     * @private
     */
    _onHidden: function() {
        this.__base.apply(this, arguments);

        this._directChannel.un('hide', this.hide, this);
    },

    /**
     * Обработчик показа блока.
     *
     * @private
     */
    _onShown: function() {
        this.__base.apply(this, arguments);

        this._directChannel.on('hide', this.hide, this);
    }
});
