/**
 * Блок `radiobox` – «радио-группа», состоящая из набора зависимых переключателей
 * «радио-кнопок» (элементы блока `radio`).
 */
BEM.DOM.decl('radiobox', {
    /**
     * Метод можно вызывать с параметром и без.
     * Вызвав без параметра получаем значение Атрибута value элемента radio, соответствующего активной кнопке.
     * Вызвав с параметром, в котором передаем значение Атрибута value произвольного элемента radio,
     * делаем активной кнопку, соответствующую этому элементу radio.
     *
     * @public
     * @param {String} [val] Значение Атрибута value какого-либо элемента radio данного блока.
     * @returns {String|BEM.DOM} Атрибут value активного элемента radio, либо объект блока
     */
    val: function(val) {

        if (typeof val === 'undefined') {
            return this._val;
        }

        var _this = this;
        this.elem('control').each(function(i, control) {
            if (control.value == val) {
                _this.setMod(_this.__self._getRadioByElem($(control)), 'checked', 'yes');
                return false;
            }
        });
        return _this;

    }

});
