BEM.DOM.decl('range-input', {
    onSetMod: {
        js: function() {
            this._inputs = {
                min: this.findBlockInside({ block: 'input', modName: 'name', modVal: 'min' }),
                max: this.findBlockInside({ block: 'input', modName: 'name', modVal: 'max' })
            }
        }
    },

    /**
     * Устанавливает/возвращает значения контрола
     * @param {Object} [value]
     * @param {*} value.min
     * @param {*} value.max
     * @returns {{min: *, max: *}|BEM}
     */
    val: function(value) {
        if (u._.isEmpty(value)) {
            return {
                min: this._inputs.min.val(),
                max: this._inputs.max.val()
            }
        }

        this._inputs.min.val(value.min);
        this._inputs.max.val(value.max);

        return this;
    },

    _onInputBlur: function() {
        this.trigger('blur', this.val());
    },

    /**
     * Реакция на изменение одного из вложенных инпутов
     * @param {Object} e
     * @private
     */
    _onInputChange: function(e) {
        var name = e.block.getMod('name');

        this.trigger('change', this.val());
    }
}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('change', 'input', function(e, data) {
            this._onInputChange(e, data);
        });
        this.liveInitOnBlockInsideEvent('blur', 'input', function(e, data) {
            this._onInputBlur(e, data);
        });
    }
});
