u.register({

    /**
     * Получение/отправка данных: условия ретаргетинга . цели/сегменты
     * @namespace retargeting-dataprovider
     */
    'retargeting-dataprovider': {

        /**
         * Возвращает доступные "цели / сегменты"
         * Обеспечивает защиту от дублирования запросов
         * returns {Promise<RetargetingGoalDTO[]>}
         * @public
         */
        getGoalList: function() {
            var promise = null;

            return function() {
                return (promise || request.call(this));
            };

            function request() {
                return promise = BEM.blocks['i-web-api-request'].retargeting.getGoals(u.consts('ulogin'))
                    .then(function(response) {
                        promise = null;

                        return response.success ? response.result : Promise.reject(response);
                    }.bind(this));
            }
        }(),

        /**
         * Замена целей условия ретаргетинга
         * @param {{ new_goal_id:number, old_goal_id:number }[]} data
         * @return {Promise}
         */
        replaceGoals: function(data) {
            return BEM.blocks['i-web-api-request'].retargeting.replaceGoals(data, u.consts('ulogin'));
        },

        /**
         * Получает данные одного условия подбора аудитории по его id
         * @param {Number} conditionId
         * @returns Promise<RetargetingConditionDTO>
         * @throws
         */
        getCondition: function(conditionId) {
            return BEM.blocks['i-web-api-request'].retargeting.getConditions([conditionId], u.consts('ulogin'))
                .then(function(response) {
                    return response.success ?
                        response.result[0] :
                        Promise.reject(response);
                }.bind(this));
        },

        /**
         * Сохраняет условия подбора аудитории
         * Если на сервер не передается id записи - будет создана новая запись
         *
         * @param {Object} condition  данные условия подбора аудитории
         * @returns {Promise<{success:boolean, id:number, condition:object}>}
         */
        saveCondition: function(condition) {
            // TODO сейчас через этот метод создается только ретаргетинг метрики, в следующем релизе тип унести
            condition = u._.extend({}, condition, { type: 'metrika_goals' });

            return BEM.blocks['i-web-api-request'].retargeting.saveCondition(condition, u.consts('ulogin'))
                .then(function(response) {
                    response.condition = u._.extend({}, condition, { id: response.id });

                    return response;
                });
        },

        /**
         * Удаляет условия подбора аудитории
         */
        deleteCondition: function(conditionIds) {
            return BEM.blocks['i-web-api-request'].retargeting.deleteCondition(conditionIds, u.consts('ulogin'));
        },

        /**
         * Выключение условий ретаргетинга
         * @param {Number[]} data - массив id выключаемых условий
         * @return {Promise}
         */
        suspendConditions: function(data) {
            return BEM.blocks['i-web-api-request'].retargeting.suspendConditions(data, u.consts('ulogin'));
        },

        /**
         * Получает прогнозное количество посетителей
         * @param {Object} condition  данные условия подбора аудитории
         * @returns {Promise<{count, errorMsg}>} объект с полями
         * если ошибки нет, errorMsg = null
         */
        forecastVisitor: function(condition) {
            return BEM.blocks['i-web-api-request'].retargeting.estimateCondition(condition, u.consts('ulogin'))
                .then(function(response) {
                    return response.success ? response : Promise.reject(response);
                });
        }

    }
});
