// jscs:disable
// jshint ignore:start
BEM.DOM.decl('select', {}, {
    /**
     * @static
     * @private
     * @param {Array} data
     * @returns {String}
     */
    _buildItemsHtml: function(data) {
        /** {String} Имя блока */
        var block = 'select',
            /** {BEMJSON} разделитель в списке элементов */
            separatorItem = { block: block, elem: 'separator', tag: 'i' };

        var items = [],
            itemsStack = [],
            inGroup = false;

        /**
         * @param {JQuery} node
         * @param {String|Object|Array} content
         * @param {Object} elMods
         * @returns {BEMJSON} BEMJSON-представление элемента
         */
        function buildItemJson(node, content, elMods) {
            var item = {
                block: 'select',
                elem: 'item',
                content: {
                    elem: 'text',
                    tag: 'span',
                    content: content || ' &nbsp; '
                },
                elemMods: {}
            };

            node.attr('mark') && (item.mark = node.attr('mark'));

            elMods && (item.elemMods = elMods);

            return item;
        }

        /**
         * @param {jQuery|HTMLElement} data
         * @param {Object} mods
         */
        function iterateNodes(data, mods) {
            var len = data.length;
            if (len) {
                var i = 0;

                do {
                    var item = $(data[i]),
                        isDisabled = item.attr('disabled') && { disabled: 'yes' };

                    if (item.is('optgroup')) {
                        inGroup = true;

                        if (!item.prev().is('optgroup') && i > 0) {
                            items.push(separatorItem);
                        }

                        itemsStack.push(items);
                        items = [];

                        items.push(buildItemJson(item, item.attr('label'),
                            $.extend({ label: 'yes' }, isDisabled, mods)));

                        iterateNodes(item.children(), $.extend({ inner: 'yes' }, isDisabled, mods));

                        var _items = items;
                        items = itemsStack.pop();

                        items.push({
                            block: 'select',
                            elem: 'group',
                            content: _items
                        });
                    } else {
                        // исполняемый код через item.html() добавить не получится, xss не возникает
                        // но при этом & заменяется на &amp;
                        // https://st.yandex-team.ru/DIRECT-69681
                        items.push(buildItemJson(item, replaceSymbols(item.html()),
                            $.extend(isDisabled, item.is(':selected') && { selected: 'yes' }, mods)));
                    }
                } while (++i < len || (inGroup = false));
            }
        }

        function replaceSymbols(html) {
            return html
                .replace(/&amp;/g, '&')
                .replace(/&gt;/g, '>')
                .replace(/&lt;/g, '<')
                .replace(/&quot;/g, '"')
                .replace(/&laquo;/g, '«')
                .replace(/&raquo;/g, '»')
        }

        iterateNodes(data);

        return BEMHTML.apply(items);
    }
});
// jshint ignore:end
