BEM.DOM.decl({ block: 'select', modName: 'from', modVal: 'floater' }, {
    onSetMod: {
        opened: {
            yes: function() {
                this.__base.apply(this, arguments);

                var floater = this._getFloater();

                floater.hasMod('fixed', 'yes') && this._togglePopupPosition();
                floater
                    .on('freeze', this._togglePopupPosition, this)
                    .on('unfreeze', this._togglePopupPosition, this);
            },

            '': function() {
                this.__base.apply(this, arguments);

                this._getFloater()
                    .un('freeze')
                    .un('unfreeze');
            }
        }
    },

    /**
     * Получает инстанс флоатера в котором находится селект
     * @returns {BEM}
     * @private
     */
    _getFloater: function() {
        return this._floater || (this._floater = this.findBlockOutside('b-floater'));
    },

    /**
     * Устанавливает или убирает модификатора position fixed для попапа  селекта и перерисовывает его, что бы он принял
     * новую позицию.
     * @private
     */
    _togglePopupPosition: function() {
        this._getPopup().toggleMod('position', 'fixed').repaint();
    }

});
