BEM.DOM.decl({ block: 'select', modName: 'type', modVal: 'multiline' }, {

    onSetMod: {

        js: {
            inited: function() {
                var mods,
                    placeholders;

                this.__base.apply(this, arguments);

                if (!this._useNativeControl()) {
                    mods = this.getMods();

                    BEM.DOM.append(this.domElem, BEMHTML.apply({
                        block: 'select',
                        elem: 'popup',
                        // нужно заменить на
                        // elemMods: u._.pick(this.getMods(), ['size', 'layout', 'theme', 'width']),
                        elemMods: {
                            size: mods.size,
                            layout: mods.layout,
                            theme: mods.theme,
                            width: mods.width
                        },
                        content: {
                            elem: 'content',
                            content: { block: 'select', elem: 'list' }
                        }
                    }));

                    // исправление отметки первого значения селекта по умолчанию, если не задано никакого
                    this.elem('control').prop('selectedIndex', this._getSelectedIndex());

                    this._staticPopup = this.elemInstance('popup');

                    // выбираем элемент до перерисовки, ...
                    placeholders = this.elem('placeholders');

                    this._redrawList();

                    // так как после неё резервирующий место элемент будет удалён и нам не нужны риски по дерганием DOM
                    placeholders.remove();
                }
            }
        }

    },

    /**
     * Обновить контент в соответствии с контентом селекта
     * @returns {BEM.DOM}
     */
    redraw: function() {
        this._staticPopup && this._redrawList();

        return this.__base.apply(this, arguments);
    },

    /**
     * Возвращает попап селекта (не блок popup, так как этот селект многострочный и не имеет выпадающего попапа)
     * @returns {BEM.DOM|null}
     * @protected
     */
    _getPopup: function() {
        return this._staticPopup || null;
    },

    /**
     * Перерисовывает список в соответствии с контентом селекта, обновляет высоту согласно размеру size раскрытого селекта
     * @returns {BEM.DOM}
     * @protected
     */
    _redrawList: function() {
        if (!this._useNativeControl()) {
            // см. islands-components/common.blocks/select/__ui/select__ui.js
            this.__base.apply(this, arguments);

            // <высота многострочного селекта> = size * <высота одного из его элементов>
            this._items.length &&
                this.domElem.height(this._items.height() * this.params.size);

            // обновление текущего выбранного элемента
            this._curItemIndex = this._getSelectedIndex();
        }

        return this;
    }

});
