BEM.DOM.decl({ block: 'select', modName: 'type', modVal: 'with-filters' }, {

    /**
     * Возвращает блок попапа. Создает его при первом обращении.
     * @returns {BEM.DOM}
     * @protected
     * @override
     */
    _getPopup: function() {
        if (this._popup) return this._popup;

        // если попап выпадает вверх, то блок с фильтром скрывается за экран,
        // поэтому делаем так, чтобы попап всегда выпадал вниз
        (this.params.popupParams || (this.params.popupParams = {})).directions = ['bottom-left'];

        var popup = this.__base.apply(this, arguments);

        this._reorganizePopupContent(popup);

        return popup;
    },

    /**
     * Реорганизует контент попапа, подписывается на события изменения и первичного применения фильтра
     * @param {BEM.DOM} popup
     * @private
     */
    _reorganizePopupContent: function(popup) {
        var filterParams = this.elemParams('filters'),
            emptyMessageBlock,
            uatraits,
            useKeyPress;

        // задаем модификатор микса select__popup_type для попапа
        this.setMod(popup.domElem, 'type', this.getMod('type'));

        // замещаем элемент блоком фильтра
        BEM.DOM.replace(this.findElem('filters'), BEMHTML.apply(filterParams.filter));

        filterParams.empty && (emptyMessageBlock = BEMHTML.apply(filterParams.empty));

        this._filters = this.findElem('filters');

        this._list = this.findElem(popup.domElem, 'list');

        // прокидываем фильтры перед списком и сам список (вырывая его со всеми слушателями и атрибутами)
        if (this.elem('info')) {
            popup.setContent([this._filters, emptyMessageBlock, this._list.detach(), this.elem('info')]);
        } else {
            popup.setContent([this._filters, emptyMessageBlock, this._list.detach()]);
        }

        emptyMessageBlock &&
            (this._emptyMessage = this.findElem(popup.domElem, 'empty-filter-result'));

        // для работы селекта с фильтрами блок на элементе filters должен реализовывать i-handle-filter
        this._filter = popup.findBlockByInterfaceOn(this._filters, 'i-handle-filter');

        // при открытии попапа фильтр может быть проинициализирован
        // вешаемся на release кнопки, так как нет другого удовлетворяющего события
        this._getButton().on('release', function() {
            // инициализация фильтра только если попап открыт
            popup.isShown() && this._filter.init(this.val());
        }, this);

        // при закрытии попапа фильтр должен быть сброшен
        popup.on('hide', function() { this._filter.reset(this.val()); }, this);

        this._filter.on('change', this._applyFilters, this);

        uatraits = u.consts('uatraits');

        // для Opera ранее v12.10 нужно слушать событие keypress
        useKeyPress = uatraits.BrowserName == 'Opera' &&
            uatraits.BrowserVersion.replace(/(\d+\.\d+).*?$/, '$1') < 12.10;

        // при нажатии стрелок вверх/вниз ходить по элементам списка
        this._filter.bindTo(useKeyPress ? 'keypress' : 'keydown', this._onKeyDown.bind(this));

        // применяем предустановленные фильтры
        this._applyFilters();
    },

    /**
     * Проверяет можно ли выделить элемент списка при хождении стрелками вверх/вниз
     * Нужно переопределить его для того, чтобы исключить спрятанные элементы при фильтрации
     * @param {jQuery} item
     * @return {Boolean}
     * @override
     * @private
     */
    _isSelectableItem: function(item) {
        // иногда в get(0) был undefined, причины неизвестны
        return item.get(0) && this.__base.apply(this, arguments) && !this.hasMod(item, 'hidden', 'yes');
    },

    /**
     * Применение фильтров
     * @private
     */
    _applyFilters: function() {
        var options = this.elem('control').children();

        // пробег по элементам с целью проверки фильтром
        this._items.each(function(i, item) {
            // просим фильтр указать, нужно ли показывать элемент с определенным значением
            this.toggleMod($(item), 'hidden', 'yes', !this._filter.filter(options.eq(i).val()));
        }.bind(this));

        this._emptyMessage &&
            this.toggleMod(this._emptyMessage, 'visible', 'yes', this._getPopup().isShown() &&
                !this._items.filter(':visible').length);

        // при открытом попапе при фильтрации надо пересчитать размеры попапа
        if (this._getPopup().isShown()) {
            this._calcPopupDimensions();
            this._scrollToCurrent();
        }
    },

    /**
     * Прокручивает список в попапе до выбранного значения
     * @private
     * @override
     */
    _scrollToCurrent: function() {
        if (!this._list || this.getSelectedIndex() < 0) return;

        var curOffsetTop = this.findElem(
                this._getPopup().domElem, 'item', 'selected', 'yes').get(0).offsetTop,
            popContent = this._list,
            popScrollTop = popContent.scrollTop(),

            disp = curOffsetTop - popScrollTop,
            fact = this._rowHeight * 2,
            newScrollTop;

        if (disp > popContent.height() - fact) {
            newScrollTop = curOffsetTop - fact;
        } else if (popScrollTop && disp < fact) {
            newScrollTop = curOffsetTop - popContent.height() + fact;
        }

        newScrollTop && popContent.scrollTop(newScrollTop);
    },

    /**
     * Рассчитывает ширину папапа и высоту списка для прокрутки
     * @protected
     * @override
     */
    _calcPopupDimensions: function() {
        var rows = +this.params.rows,
            allRows,
            hiddenRows,
            height;

        // это нужно и тут и в других частях блока select
        this._popupContent || (this._popupContent = this._getPopup().elem('content'));

        // принудительно задаем ширину, так как ширина фильтра может быть больше ширины списка (есть баги в ИЕ)
        var maxPopupContentWidth = Math.max(this._popupContent.outerWidth(), this.elem('button').width()),
            popupContentWidth = maxPopupContentWidth > 400 ? 400 : maxPopupContentWidth;

        this._popupContent.width(popupContentWidth);

        if (rows) {
            allRows = this.findElem(this._list, 'item').size();
            hiddenRows = this.findElem(this._list, 'item', 'hidden', 'yes').size();
        }

        // если строк больше, чем можем показать, то включаем скрол на списке
        this.toggleMod(this._list, 'scrollable', 'yes', !!rows && (allRows - hiddenRows) > rows);

        // если есть скрол на списке, то вычисляем его высоту
        if (this.hasMod(this._list, 'scrollable', 'yes')) {
            this._rowHeight = this._getRowHeight();

            height = rows * this._rowHeight;
        }

        // и затем её задаём
        this._list.height(height || '');

        // для пересчета позиции попапа надо попросить его перерисоваться
        this._getPopup().repaint();
    },

    /**
     * Переопределение обработчика для отмены закрытия попапа при потере фокуса кнопкой селекта
     * и для передаче фокуса элементам фильтра
     * @private
     * @override
     */
    _onButtonBlur: function() {
        // если в фокусе что то, что принадлежит фильтру, то выходим
        //if (this._filters && $.contains(this._filters.get(0), this.__self.doc.get(0).activeElement)) return;

        //return this.__base.apply(this, arguments);
        //DIRECT-51183
        //heliarian - нам не надо переопределять фокус - фокус должен стоять на поле ввода
    }

});
